/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.helper;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class GenerationHelper
implements Closeable {
    private int whitespaces;
    private PrintWriter writer;

    public GenerationHelper(Writer sourceWriter) {
        this.initializeSourceWriter(sourceWriter);
    }

    public static String implode(Object[] segments, String delimiter) {
        String implodedString;
        if (segments.length == 0) {
            implodedString = "";
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(segments[0]);
            for (int i = 1; i < segments.length; ++i) {
                if (segments[i] == null || segments[i].toString().isEmpty()) continue;
                sb.append(delimiter);
                sb.append(segments[i]);
            }
            implodedString = sb.toString();
        }
        return implodedString;
    }

    public static String replaceParameters(String target, Object ... parameters) {
        String result = target;
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                result = result.replace("{" + i + "}", String.valueOf(parameters[i]));
            }
        }
        return result;
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public String firstCharToUpperCase(String charSequence) {
        String upperCased = "";
        upperCased = upperCased + charSequence.substring(0, 1).toUpperCase();
        upperCased = upperCased + charSequence.substring(1);
        return upperCased;
    }

    public void generateAnnotation(String className, String value) {
        if (value == null) {
            this.println("@{0}", className);
        } else {
            this.println("@{0}({1})", className, value);
        }
    }

    public void generateConstantFieldDeclaration(VariableElement fieldElement) {
        if (this.isConstant(fieldElement)) {
            String constantValue = this.determineFinalConstantValue(fieldElement);
            if (constantValue != null) {
                this.println("  {0}{1} {2} = {3};", this.generateModifierList(fieldElement.getModifiers().toArray(new Modifier[0])), fieldElement.asType().toString(), fieldElement.getSimpleName(), constantValue);
            } else {
                this.println("  {0}{1} {2};", this.generateModifierList(fieldElement.getModifiers().toArray(new Modifier[0])), fieldElement.asType().toString(), fieldElement.getSimpleName());
            }
        }
    }

    public void generateFieldDeclaration(VariableElement fieldElement) {
        this.println("  {0}{1} {2};", this.generateModifierList(fieldElement.getModifiers().toArray(new Modifier[0])), fieldElement.asType().toString(), fieldElement.getSimpleName());
    }

    public void generateFieldDeclaration(VariableElement fieldElement, Modifier ... modifiers) {
        this.println("  {0}{1} {2};", this.generateModifierList(modifiers), fieldElement.asType().toString(), fieldElement.getSimpleName());
    }

    public void generateFieldDeclarations(Collection<VariableElement> collection) {
        this.println();
        this.println();
        for (VariableElement fieldElement : collection) {
            if (this.isConstant(fieldElement)) {
                this.generateConstantFieldDeclaration(fieldElement);
                continue;
            }
            this.generateFieldDeclaration(fieldElement);
        }
    }

    public String generateFieldList(Collection<VariableElement> fieldElements, boolean withType, boolean leadingComma) {
        StringBuilder fieldList = new StringBuilder();
        if (fieldElements != null && fieldElements.size() > 0) {
            int i = 0;
            for (VariableElement fieldElement : fieldElements) {
                if (leadingComma || i++ > 0) {
                    fieldList.append(", ");
                }
                if (withType) {
                    fieldList.append(fieldElement.asType().toString()).append(" ");
                }
                fieldList.append(fieldElement.getSimpleName());
            }
        }
        return fieldList.toString();
    }

    public void generateFooter() {
        this.println("}");
    }

    public void generateImports(Class<?> ... imports) {
        this.println();
        for (Class<?> importClass : imports) {
            if (importClass == null) {
                this.println();
                continue;
            }
            this.println("import {0};", importClass.getName());
        }
    }

    public void generateImports(String ... imports) {
        this.println();
        for (String importClass : imports) {
            if (importClass == null) {
                this.println();
                continue;
            }
            this.println("import {0};", importClass);
        }
    }

    public String generateModifierList(Modifier ... modifiers) {
        String fieldModifier = "";
        if (modifiers != null && modifiers.length > 0) {
            fieldModifier = GenerationHelper.implode((Object[])modifiers, " ");
        }
        return fieldModifier.isEmpty() ? fieldModifier : fieldModifier + " ";
    }

    public void generatePackageDeclaration(String packageName) {
        this.println("package {0};", packageName);
    }

    public boolean isConstant(VariableElement fieldElement) {
        return fieldElement.getModifiers().contains((Object)Modifier.STATIC) || fieldElement.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isFinal(VariableElement fieldElement) {
        return fieldElement.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isPrimitive(TypeMirror type) {
        String typeName = type.toString();
        if (typeName.equals("byte")) {
            return true;
        }
        if (typeName.equals("short")) {
            return true;
        }
        if (typeName.equals("int")) {
            return true;
        }
        if (typeName.equals("long")) {
            return true;
        }
        if (typeName.equals("float")) {
            return true;
        }
        if (typeName.equals("double")) {
            return true;
        }
        if (typeName.equals("char")) {
            return true;
        }
        return typeName.equals("boolean");
    }

    public boolean isStatic(VariableElement fieldElement) {
        return fieldElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    public String manufactureField(VariableElement fieldElement) {
        return fieldElement.asType().toString() + " " + fieldElement.getSimpleName();
    }

    public void print(Object o) {
        this.writer.print(this.manufactureIndentation() + o);
    }

    public void print(String s, Object ... parameters) {
        this.print(GenerationHelper.replaceParameters(s, parameters));
    }

    public void println() {
        this.writer.println();
    }

    public void println(Object o) {
        this.writer.println(this.manufactureIndentation() + o);
    }

    public void println(String s, Object ... parameters) {
        this.println(GenerationHelper.replaceParameters(s, parameters));
    }

    public void printWithoutSpaces(String s, Object ... parameters) {
        this.writer.print(GenerationHelper.replaceParameters(s, parameters));
    }

    public void resetWhitespaces() {
        this.whitespaces = 0;
    }

    public void setWhitespaces(int whitespace) {
        this.whitespaces = whitespace;
    }

    protected String determineFinalConstantValue(VariableElement fieldElement) {
        Object fieldConstantValue = fieldElement.getConstantValue();
        String determinedConstantValue = null;
        if (fieldConstantValue instanceof String) {
            determinedConstantValue = "\"" + String.valueOf(fieldConstantValue) + "\"";
        } else if (fieldConstantValue instanceof Character) {
            determinedConstantValue = "'" + String.valueOf(fieldConstantValue) + "'";
        } else if (this.isPrimitive(fieldElement.asType()) && "null".equals(determinedConstantValue = String.valueOf(fieldConstantValue))) {
            determinedConstantValue = null;
        }
        return determinedConstantValue;
    }

    protected String determineWrapperClass(TypeMirror type) {
        String typeName = type.toString();
        if (typeName.equals("byte")) {
            return Byte.class.getSimpleName();
        }
        if (typeName.equals("short")) {
            return Short.class.getSimpleName();
        }
        if (typeName.equals("int")) {
            return Integer.class.getSimpleName();
        }
        if (typeName.equals("long")) {
            return Long.class.getSimpleName();
        }
        if (typeName.equals("float")) {
            return Float.class.getSimpleName();
        }
        if (typeName.equals("double")) {
            return Double.class.getSimpleName();
        }
        if (typeName.equals("char")) {
            return Character.class.getSimpleName();
        }
        if (typeName.equals("boolean")) {
            return Boolean.class.getSimpleName();
        }
        return null;
    }

    protected String manufactureAccessorName(VariableElement fieldElement) {
        String name = fieldElement.asType().toString().equals(Boolean.class.getSimpleName().toLowerCase()) ? "is" : "get";
        name = name + this.firstCharToUpperCase(fieldElement.getSimpleName().toString());
        return name;
    }

    protected String manufactureSetterName(String fieldName) {
        String name = "set";
        name = name + this.firstCharToUpperCase(fieldName);
        return name;
    }

    protected String manufactureSetterName(VariableElement fieldElement) {
        return this.manufactureSetterName(fieldElement.getSimpleName().toString());
    }

    protected String manufactureIndentation() {
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < this.whitespaces; ++i) {
            space.append(" ");
        }
        return space.toString();
    }

    private void initializeSourceWriter(Writer sourceWriter) {
        BufferedWriter bufferedWriter = new BufferedWriter(sourceWriter);
        this.writer = new PrintWriter(bufferedWriter);
    }
}

