/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.helper;

import com.gwtplatform.dispatch.annotation.In;
import com.gwtplatform.dispatch.annotation.Optional;
import com.gwtplatform.dispatch.annotation.Order;
import com.gwtplatform.dispatch.annotation.Out;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

public class ReflectionHelper {
    private TypeElement classRepresenter;
    private ProcessingEnvironment environment;

    public ReflectionHelper(ProcessingEnvironment environment, TypeElement classRepresenter) {
        this.classRepresenter = classRepresenter;
        this.environment = environment;
    }

    public Collection<VariableElement> filterConstantFields(Collection<VariableElement> fieldElements) {
        return this.filterFields(fieldElements, Modifier.STATIC, Modifier.FINAL);
    }

    public Collection<VariableElement> filterFields(Collection<VariableElement> fieldElements, Class<? extends Annotation> ... annotations) {
        ArrayList<VariableElement> filteredFields = new ArrayList<VariableElement>();
        filteredFields.addAll(fieldElements);
        block0: for (VariableElement fieldElement : fieldElements) {
            for (Class<? extends Annotation> passedAnnotation : annotations) {
                Annotation fieldAnnotation = fieldElement.getAnnotation(passedAnnotation);
                if (fieldAnnotation == null) continue;
                filteredFields.remove(fieldElement);
                continue block0;
            }
        }
        return filteredFields;
    }

    public Collection<VariableElement> filterFields(Collection<VariableElement> fieldElements, Modifier ... modifiers) {
        ArrayList<VariableElement> filteredFields = new ArrayList<VariableElement>();
        filteredFields.addAll(fieldElements);
        block0: for (VariableElement fieldElement : fieldElements) {
            for (Modifier modifier : modifiers) {
                if (!fieldElement.getModifiers().contains((Object)modifier)) continue;
                filteredFields.remove(fieldElement);
                continue block0;
            }
        }
        return filteredFields;
    }

    public Collection<VariableElement> filterFields(Collection<VariableElement> fieldElements, String ... simpleFieldNames) {
        ArrayList<VariableElement> filteredFields = new ArrayList<VariableElement>();
        filteredFields.addAll(fieldElements);
        block0: for (VariableElement fieldElement : fieldElements) {
            for (String simpleFieldName : simpleFieldNames) {
                if (!fieldElement.getSimpleName().toString().equals(simpleFieldName)) continue;
                filteredFields.remove(fieldElement);
                continue block0;
            }
        }
        return filteredFields;
    }

    public Collection<VariableElement> getAnnotatedFields(Class<? extends Annotation> ... annotations) {
        Collection<VariableElement> fieldsCopy = this.getFields();
        for (Class<? extends Annotation> annotation : annotations) {
            Collection<VariableElement> nonAnnotatedFields = this.filterFields(this.getFields(), annotation);
            fieldsCopy.removeAll(nonAnnotatedFields);
        }
        return fieldsCopy;
    }

    public String getClassName() {
        return this.getPackageName() + '.' + this.getSimpleClassName();
    }

    public TypeElement getClassRepresenter() {
        return this.classRepresenter;
    }

    public Collection<VariableElement> getConstantFields() {
        return this.getModifierFields(Modifier.FINAL, Modifier.STATIC);
    }

    public Collection<VariableElement> getFields() {
        List<? extends Element> members = this.getElementUtils().getAllMembers(this.classRepresenter);
        return ElementFilter.fieldsIn(members);
    }

    public Collection<VariableElement> getFinalFields() {
        return this.filterFields(this.getOrderedFields(), Modifier.FINAL);
    }

    public Collection<VariableElement> getInFields() {
        return this.sortFields(In.class, this.getAnnotatedFields(In.class));
    }

    public Collection<VariableElement> getModifierFields(Modifier ... modifiers) {
        ArrayList<VariableElement> modifierFields = new ArrayList<VariableElement>();
        modifierFields.addAll(this.getFields());
        for (Modifier modifier : modifiers) {
            Collection<VariableElement> nonModifierFields = this.filterFields(this.getFields(), modifier);
            modifierFields.removeAll(nonModifierFields);
        }
        return modifierFields;
    }

    public Collection<VariableElement> getNonConstantFields() {
        return this.filterFields(this.getOrderedFields(), Modifier.FINAL, Modifier.STATIC);
    }

    public Collection<VariableElement> getOptionalFields() {
        return this.sortFields(Order.class, this.filterConstantFields(this.getAnnotatedFields(Optional.class)));
    }

    public Collection<VariableElement> getOptionalFields(Class<? extends Annotation> annotation) {
        return this.filterConstantFields(this.getAnnotatedFields(Optional.class, annotation));
    }

    public Collection<VariableElement> getOrderedFields() {
        return this.sortFields(Order.class, this.getFields());
    }

    public Collection<VariableElement> getOutFields() {
        return this.sortFields(Out.class, this.getAnnotatedFields(Out.class));
    }

    public String getPackageName() {
        return this.getElementUtils().getPackageOf(this.classRepresenter).getQualifiedName().toString();
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.environment;
    }

    public Collection<VariableElement> getRequiredFields() {
        Collection<VariableElement> fields = this.getFields();
        fields.removeAll(this.getOptionalFields());
        fields = this.filterFields(fields, Modifier.FINAL, Modifier.STATIC);
        return this.sortFields(Order.class, fields);
    }

    public String getSimpleClassName() {
        return this.classRepresenter.getSimpleName().toString();
    }

    public Collection<VariableElement> getStaticFields() {
        return this.filterFields(this.getOrderedFields(), Modifier.STATIC);
    }

    public Collection<VariableElement> sortFields(Class<? extends Annotation> annotation, Collection<VariableElement> fields) {
        TreeMap<Integer, VariableElement> sortedFields = new TreeMap<Integer, VariableElement>();
        if (In.class.equals(annotation)) {
            this.sortInFields(sortedFields, fields);
        } else if (Out.class.equals(annotation)) {
            this.sortOutFields(sortedFields, fields);
        } else if (Order.class.equals(annotation)) {
            this.sortOrderFields(sortedFields, fields);
        } else {
            return fields;
        }
        return sortedFields.values();
    }

    public boolean hasOptionalFields() {
        return this.getOptionalFields().size() > 0;
    }

    public boolean hasRequiredFields() {
        return this.getRequiredFields().size() > 0;
    }

    protected Elements getElementUtils() {
        return this.environment.getElementUtils();
    }

    protected void sortInFields(SortedMap<Integer, VariableElement> sortedFields, Collection<VariableElement> fields) {
        for (VariableElement fieldElement : fields) {
            In inFieldAnnotation = fieldElement.getAnnotation(In.class);
            if (inFieldAnnotation == null) continue;
            sortedFields.put(inFieldAnnotation.value(), fieldElement);
        }
    }

    protected void sortOrderFields(SortedMap<Integer, VariableElement> sortedFields, Collection<VariableElement> fields) {
        Order order;
        int maxOrderNum = -1;
        for (VariableElement fieldElement : fields) {
            order = fieldElement.getAnnotation(Order.class);
            if (order == null) continue;
            maxOrderNum = Math.max(maxOrderNum, order.value());
        }
        for (VariableElement fieldDecl : fields) {
            order = fieldDecl.getAnnotation(Order.class);
            if (order != null) {
                maxOrderNum = Math.max(maxOrderNum, order.value());
                sortedFields.put(order.value(), fieldDecl);
                continue;
            }
            sortedFields.put(++maxOrderNum, fieldDecl);
        }
    }

    protected void sortOutFields(SortedMap<Integer, VariableElement> sortedFields, Collection<VariableElement> fields) {
        for (VariableElement fieldElement : fields) {
            Out outFieldAnnotation = fieldElement.getAnnotation(Out.class);
            if (outFieldAnnotation == null) continue;
            sortedFields.put(outFieldAnnotation.value(), fieldElement);
        }
    }
}

