/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.processor;

import com.google.web.bindery.requestfactory.shared.Locator;
import com.gwtplatform.dispatch.annotation.GenProxy;
import com.gwtplatform.dispatch.annotation.UseProxy;
import com.gwtplatform.dispatch.annotation.UseProxyName;
import com.gwtplatform.dispatch.annotation.helper.GenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.InterfaceGenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.ReflectionHelper;
import com.gwtplatform.dispatch.annotation.processor.GenProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"com.gwtplatform.dispatch.annotation.GenProxy"})
public class GenProxyProcessor
extends GenProcessor {
    @Override
    public void process(Element proxyElement) {
        GenProxy genProxy = proxyElement.getAnnotation(GenProxy.class);
        this.generateProxy(proxyElement, genProxy.targetPackage(), genProxy.filterSetter(), genProxy.filterGetter(), genProxy.isEmbeddedType(), this.getLocatorTypeMirror(genProxy));
    }

    protected void generateProxy(Element proxyElement, String targetPackage, String[] filterSetter, String[] filterGetter, boolean isEmbeddedType, TypeMirror locatorType) {
        GenerationHelper writer = null;
        try {
            ReflectionHelper reflection = new ReflectionHelper(this.getEnvironment(), (TypeElement)proxyElement);
            String proxyElementSimpleName = reflection.getSimpleClassName();
            String proxyElementClassName = reflection.getClassName();
            String proxyElementPackage = reflection.getPackageName();
            String preparedProxyElementClassName = proxyElementClassName.replace(".server", ".shared");
            String preparedProxyElementPackage = proxyElementPackage.replace(".server", ".shared");
            if (targetPackage != null && !targetPackage.isEmpty()) {
                preparedProxyElementClassName = targetPackage + "." + proxyElementSimpleName;
                preparedProxyElementPackage = targetPackage;
            }
            String proxySimpleName = proxyElementSimpleName + "Proxy";
            String proxyClassName = preparedProxyElementClassName + "Proxy";
            Writer sourceWriter = this.getEnvironment().getFiler().createSourceFile(proxyClassName, proxyElement).openWriter();
            writer = new InterfaceGenerationHelper(sourceWriter);
            writer.generatePackageDeclaration(preparedProxyElementPackage);
            if (isEmbeddedType) {
                this.generateValueProxyHeader((InterfaceGenerationHelper)writer, reflection, proxyElementClassName, proxySimpleName);
            } else {
                this.generateEntityProxyHeader((InterfaceGenerationHelper)writer, reflection, proxyElementClassName, proxySimpleName, locatorType);
            }
            writer.println();
            Collection<VariableElement> allFields = reflection.getNonConstantFields();
            Collection<VariableElement> getterFields = reflection.filterFields(allFields, filterGetter);
            for (VariableElement getterField : getterFields) {
                this.generateGetter((InterfaceGenerationHelper)writer, getterField);
            }
            Collection<VariableElement> setterFields = reflection.filterFields(allFields, filterSetter);
            for (VariableElement setterField : setterFields) {
                this.generateSetter((InterfaceGenerationHelper)writer, setterField);
            }
            writer.println();
            writer.generateFooter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void generateEntityProxyHeader(InterfaceGenerationHelper writer, ReflectionHelper reflection, String proxyElementClassName, String proxySimpleName, TypeMirror locatorType) {
        writer.generateImports("com.google.web.bindery.requestfactory.shared.ProxyFor", "com.google.web.bindery.requestfactory.shared.EntityProxy", "com.google.web.bindery.requestfactory.shared.EntityProxyId");
        writer.println();
        if (locatorType == null || Locator.class.getName().equals(locatorType.toString())) {
            writer.generateAnnotation("ProxyFor", proxyElementClassName + ".class");
        } else {
            writer.println("@{0}(value = {1}.class, locator = {2}.class)", "ProxyFor", proxyElementClassName, locatorType.toString());
        }
        writer.generateInterfaceHeader(proxySimpleName, reflection.getClassRepresenter().getModifiers(), "EntityProxy");
        writer.println();
        writer.generateEmptyMethodBody("stableId", "EntityProxyId<" + proxySimpleName + ">");
    }

    protected void generateValueProxyHeader(InterfaceGenerationHelper writer, ReflectionHelper reflection, String proxyElementClassName, String proxySimpleName) {
        writer.generateImports("com.google.web.bindery.requestfactory.shared.ProxyFor", "com.google.web.bindery.requestfactory.shared.ValueProxy");
        writer.println();
        writer.generateAnnotation("ProxyFor", proxyElementClassName + ".class");
        writer.generateInterfaceHeader(proxySimpleName, reflection.getClassRepresenter().getModifiers(), "ValueProxy");
    }

    protected void generateGetter(InterfaceGenerationHelper writer, VariableElement getterField) {
        UseProxy useProxyAnnotation = getterField.getAnnotation(UseProxy.class);
        UseProxyName useProxyNameAnnotation = getterField.getAnnotation(UseProxyName.class);
        if (useProxyAnnotation != null) {
            writer.generateGetter(getterField.getSimpleName().toString(), this.getProxyTypeMirrorName(useProxyAnnotation, getterField.asType()));
        } else if (useProxyNameAnnotation != null) {
            writer.generateGetter(getterField.getSimpleName().toString(), useProxyNameAnnotation.value());
        } else {
            writer.generateGetter(getterField);
        }
    }

    protected void generateSetter(InterfaceGenerationHelper writer, VariableElement setterField) {
        UseProxy useProxyAnnotation = setterField.getAnnotation(UseProxy.class);
        UseProxyName useProxyNameAnnotation = setterField.getAnnotation(UseProxyName.class);
        if (useProxyAnnotation != null) {
            writer.generateSetter(setterField.getSimpleName().toString(), this.getProxyTypeMirrorName(useProxyAnnotation, setterField.asType()));
        } else if (useProxyNameAnnotation != null) {
            writer.generateSetter(setterField.getSimpleName().toString(), useProxyNameAnnotation.value());
        } else {
            writer.generateSetter(setterField);
        }
    }

    protected final String getProxyTypeMirrorName(UseProxy useProxyAnnotation, TypeMirror originalTypeMirror) {
        TypeMirror mirror = null;
        try {
            useProxyAnnotation.value();
        }
        catch (MirroredTypeException e) {
            mirror = e.getTypeMirror();
        }
        return this.nestIntoCollectionIfNecessary(mirror, originalTypeMirror);
    }

    private String nestIntoCollectionIfNecessary(TypeMirror mirror, TypeMirror originalTypeMirror) {
        String originalTypeDeclaration = originalTypeMirror.toString();
        if (!originalTypeDeclaration.contains("<") || !originalTypeDeclaration.contains(">")) {
            return mirror.toString();
        }
        String collectionClassName = originalTypeDeclaration.substring(0, originalTypeDeclaration.indexOf("<"));
        Class collectionClass = this.tryRetrieveCollectionClass(collectionClassName);
        StringBuilder builder = new StringBuilder();
        if (collectionClass != null && (this.isAssignableToSet(collectionClass) || this.isAssignableToList(collectionClass))) {
            builder.append(collectionClassName).append("<").append(mirror.toString()).append(">");
        } else {
            builder.append(mirror.toString());
        }
        return builder.toString();
    }

    private Class tryRetrieveCollectionClass(String collectionClassName) {
        try {
            return Class.forName(collectionClassName);
        }
        catch (ClassNotFoundException e) {
            this.printMessage("Potential collection class " + collectionClassName + " could not be found.");
            return null;
        }
    }

    private boolean isAssignableToSet(Class collectionClass) {
        if (collectionClass.equals(Set.class)) {
            return true;
        }
        for (Class<?> interfaceClass : collectionClass.getInterfaces()) {
            if (!interfaceClass.equals(Set.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableToList(Class collectionClass) {
        if (collectionClass.equals(List.class)) {
            return true;
        }
        for (Class<?> interfaceClass : collectionClass.getInterfaces()) {
            if (!interfaceClass.equals(List.class)) continue;
            return true;
        }
        return false;
    }

    protected final TypeMirror getLocatorTypeMirror(GenProxy genProxyAnnotation) {
        TypeMirror mirror = null;
        try {
            genProxyAnnotation.locator();
        }
        catch (MirroredTypeException e) {
            mirror = e.getTypeMirror();
        }
        return mirror;
    }
}

