/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.it.shared;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@RunAsClient
public abstract class AbstractDebugServletIT {
    public static final String JBOSS_NODE_NAME = "clusterbench-1";

    @Test
    public void test() throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet("http://localhost:8080/clusterbench/debug");
            httpClient.execute((ClassicHttpRequest)httpGet, response -> {
                Assertions.assertEquals((int)200, (int)response.getCode());
                HttpEntity entity = response.getEntity();
                Optional<String> optionalNodeName = new BufferedReader(new InputStreamReader(entity.getContent())).lines().filter(line -> line.startsWith("Node name:")).map(line -> {
                    String[] split = line.split(":");
                    return split[1].trim();
                }).findFirst();
                if (optionalNodeName.isPresent()) {
                    Assertions.assertEquals((Object)JBOSS_NODE_NAME, (Object)optionalNodeName.get());
                } else {
                    Assertions.fail((String)"Missing node name.");
                }
                return null;
            });
        }
    }
}

