/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.it.shared;

import java.util.Arrays;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@RunAsClient
public abstract class AbstractHttpSessionServletIT {
    @Test
    public void test() throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet("http://localhost:8080/clusterbench/session");
            httpClient.execute((ClassicHttpRequest)httpGet, response -> {
                Assertions.assertEquals((int)200, (int)response.getCode());
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                Assertions.assertEquals((Object)"0", (Object)responseBody);
                Optional<String> jsessionIdCookie = Arrays.stream(response.getHeaders("Set-Cookie")).map(NameValuePair::getValue).filter(cookie -> cookie.startsWith("JSESSIONID=")).findFirst();
                Assertions.assertTrue((boolean)jsessionIdCookie.isPresent());
                return null;
            });
            httpClient.execute((ClassicHttpRequest)httpGet, response -> {
                Assertions.assertEquals((int)200, (int)response.getCode());
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                Assertions.assertEquals((Object)"1", (Object)responseBody);
                return null;
            });
        }
    }
}

