/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.utils.testng;

import java.util.Date;
import org.jboss.test.selenium.utils.testng.TestInfo;
import org.testng.ITestResult;

public final class TestLoggingUtils {
    private TestLoggingUtils() {
    }

    public static String getTestDescription(ITestResult result, boolean isTestStart) {
        String methodName = TestInfo.getMethodName(result);
        String status = TestInfo.STATUSES.get(result.getStatus());
        StringBuilder parameters = new StringBuilder("(");
        if (result.getParameters() != null && result.getParameters().length != 0) {
            for (int i = 0; i < result.getParameters().length; ++i) {
                parameters.append("\"");
                parameters.append(result.getParameters()[i]);
                parameters.append(i == result.getParameters().length - 1 ? "\"" : "\", ");
            }
        }
        parameters.append(")");
        String invocationCount = "";
        if (result.getMethod().getInvocationCount() > 1) {
            int count = result.getMethod().getCurrentInvocationCount();
            invocationCount = String.format(" [%d]", count += isTestStart ? 1 : 0);
        }
        String message = String.format("[%tT] %s: %s%s%s", new Date(), status.toUpperCase(), methodName, parameters.toString(), invocationCount);
        return message;
    }
}

