/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class ElementPresent
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private ElementLocator elementLocator;

    protected ElementPresent() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull((Object)this.elementLocator);
        return this.selenium.isElementPresent(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.getAsString());
        return JavaScript.js(SimplifiedFormat.format("selenium.isElementPresent('{0}')", escapedLocator));
    }

    public static ElementPresent getInstance() {
        return new ElementPresent();
    }

    public ElementPresent locator(ElementLocator elementLocator) {
        Validate.notNull((Object)elementLocator);
        ElementPresent copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private ElementPresent copy() {
        ElementPresent copy = new ElementPresent();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

