/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.test.selenium.SystemProperties;
import org.jboss.test.selenium.browser.Browser;
import org.jboss.test.selenium.browser.BrowserMode;
import org.jboss.test.selenium.browser.BrowserType;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumImpl;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.ElementLocationStrategy;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.Wait;
import org.jboss.test.selenium.waiting.ajax.AjaxWaiting;
import org.jboss.test.selenium.waiting.conditions.AlertEquals;
import org.jboss.test.selenium.waiting.conditions.AlertPresent;
import org.jboss.test.selenium.waiting.conditions.AttributeEquals;
import org.jboss.test.selenium.waiting.conditions.AttributePresent;
import org.jboss.test.selenium.waiting.conditions.CountEquals;
import org.jboss.test.selenium.waiting.conditions.ElementPresent;
import org.jboss.test.selenium.waiting.conditions.StyleEquals;
import org.jboss.test.selenium.waiting.conditions.TextEquals;
import org.jboss.test.selenium.waiting.retrievers.AttributeRetriever;
import org.jboss.test.selenium.waiting.retrievers.TextRetriever;
import org.jboss.test.selenium.waiting.selenium.SeleniumWaiting;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public abstract class AbstractTestCase {
    private static final int WAIT_GUI_INTERVAL = 100;
    private static final int WAIT_AJAX_INTERVAL = 500;
    private static final int WAIT_MODEL_INTERVAL = 1500;
    protected AjaxSelenium selenium;
    protected AjaxWaiting waitGui;
    protected AjaxWaiting waitAjax;
    protected SeleniumWaiting waitModel;
    protected ElementPresent elementPresent = ElementPresent.getInstance();
    protected TextEquals textEquals = TextEquals.getInstance();
    protected StyleEquals styleEquals = StyleEquals.getInstance();
    protected AttributePresent attributePresent = AttributePresent.getInstance();
    protected AttributeEquals attributeEquals = AttributeEquals.getInstance();
    protected AlertPresent alertPresent = AlertPresent.getInstance();
    protected AlertEquals alertEquals = AlertEquals.getInstance();
    protected CountEquals countEquals = CountEquals.getInstance();
    protected TextRetriever retrieveText = TextRetriever.getInstance();
    protected AttributeRetriever retrieveAttribute = AttributeRetriever.getInstance();
    protected URL contextRoot;
    protected URL contextPath;
    protected File mavenProjectBuildDirectory;
    protected File mavenResourcesDir;
    protected boolean seleniumDebug;
    protected Browser browser;

    @BeforeClass(alwaysRun=true)
    public void initializeParameters() throws MalformedURLException {
        this.seleniumDebug = SystemProperties.isSeleniumDebug();
        this.contextRoot = SystemProperties.getContextRoot();
        this.contextPath = SystemProperties.getContextPath();
        this.mavenResourcesDir = SystemProperties.getMavenResourcesDir();
        this.mavenProjectBuildDirectory = SystemProperties.getMavenProjectBuildDirectory();
        this.browser = SystemProperties.getBrowser();
    }

    @BeforeClass(dependsOnMethods={"initializeParameters", "isTestBrowserEnabled"}, alwaysRun=true)
    public void initializeBrowser() {
        this.selenium = new AjaxSeleniumImpl(SystemProperties.getSeleniumHost(), SystemProperties.getSeleniumPort(), this.browser, this.contextPath);
        AjaxSeleniumProxy.setCurrentContext(this.selenium);
        this.selenium.enableNetworkTrafficCapturing(SystemProperties.isSeleniumNetworkTrafficEnabled());
        this.selenium.start();
        this.loadCustomLocationStrategies();
        this.selenium.setSpeed(SystemProperties.getSeleniumSpeed());
        if (SystemProperties.isSeleniumMaximize()) {
            this.selenium.windowFocus();
            this.selenium.windowMaximize();
        }
    }

    @BeforeClass(alwaysRun=true, dependsOnMethods={"initializeBrowser"})
    public void initializeWaitTimeouts() {
        this.selenium.setTimeout(SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.DEFAULT));
        this.waitGui = (AjaxWaiting)((AjaxWaiting)Wait.waitAjax().interval(100L)).timeout(SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.GUI));
        this.waitAjax = (AjaxWaiting)((AjaxWaiting)Wait.waitAjax().interval(500L)).timeout(SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.AJAX));
        this.waitModel = (SeleniumWaiting)((SeleniumWaiting)Wait.waitSelenium().interval(1500L)).timeout(SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.MODEL));
    }

    @BeforeClass(dependsOnMethods={"initializeBrowser"}, alwaysRun=true)
    public void initializeExtensions() throws IOException {
        List seleniumExtensions = IOUtils.readLines((InputStream)ClassLoader.getSystemResourceAsStream("javascript/selenium-extensions-order.txt"));
        List pageExtensions = IOUtils.readLines((InputStream)ClassLoader.getSystemResourceAsStream("javascript/page-extensions-order.txt"));
        this.selenium.getSeleniumExtensions().requireResources(seleniumExtensions);
        this.selenium.getSeleniumExtensions().registerCustomHandlers();
        this.selenium.getPageExtensions().loadFromResources(pageExtensions);
    }

    private void loadCustomLocationStrategies() {
        JavaScript strategySource = JavaScript.fromResource("javascript/selenium-location-strategies/jquery-location-strategy.js");
        this.selenium.addLocationStrategy(ElementLocationStrategy.JQUERY, strategySource);
    }

    @AfterClass(alwaysRun=true)
    public void finalizeBrowser() {
        if (this.selenium != null && this.selenium.isStarted()) {
            AjaxSeleniumProxy.setCurrentContext(null);
            this.selenium.stop();
            this.selenium = null;
        }
    }

    @Parameters(value={"enabled-browsers", "disabled-browsers", "enabled-modes", "disabled-modes"})
    @BeforeClass(dependsOnMethods={"initializeParameters"}, alwaysRun=true)
    public void isTestBrowserEnabled(@Optional(value="*") String enabledBrowsersParam, @Optional(value="") String disabledBrowsersParam, @Optional(value="*") String enabledModesParam, @Optional(value="") String disabledModesParam) {
        EnumSet<BrowserType> enabledBrowserTypes = BrowserType.parseTypes(enabledBrowsersParam);
        EnumSet<BrowserType> disabledBrowserTypes = BrowserType.parseTypes(disabledBrowsersParam);
        EnumSet<BrowserMode> enabledBrowserModes = BrowserMode.parseModes(enabledModesParam);
        EnumSet<BrowserMode> disabledBrowserModes = BrowserMode.parseModes(disabledModesParam);
        enabledBrowserTypes.removeAll(disabledBrowserTypes);
        enabledBrowserModes.addAll(BrowserMode.getModesFromTypes(enabledBrowserTypes));
        enabledBrowserModes.removeAll(disabledBrowserModes);
        if (!enabledBrowserModes.contains((Object)this.browser.getMode())) {
            throw new SkipException(SimplifiedFormat.format("This test isn't supported in {0}", this.browser));
        }
    }
}

