/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.utils.testng;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.testng.ITestResult;

public final class TestInfo {
    public static final Map<Integer, String> STATUSES = Collections.unmodifiableMap(new TreeMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(2, "Failure");
            this.put(3, "Skip");
            this.put(16, "Started");
            this.put(1, "Success");
            this.put(4, "FailurePercentage");
        }
    });

    private TestInfo() {
    }

    public static String getClassMethodName(ITestResult result) {
        return TestInfo.getClassName(result) + "." + TestInfo.getMethodName(result);
    }

    public static String getMethodName(ITestResult result) {
        Method method = result.getMethod().getMethod();
        return method.getName();
    }

    public static String getClassName(ITestResult result) {
        Class<?> dClass = result.getMethod().getMethod().getDeclaringClass();
        return dClass.getSimpleName();
    }

    public static String getContainingPackageName(ITestResult result) {
        Package dPackage = result.getMethod().getMethod().getDeclaringClass().getPackage();
        return dPackage.getName().replaceFirst("^.*\\.", "");
    }
}

