/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.framework.internal;

import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;

public class SeleniumExtensions {
    AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    final JavaScript getScriptWithResourceName = JavaScript.fromResource("javascript/get-script-with-resourcename.js");
    final JavaScript containsScriptWithResourceName = this.getScriptWithResourceName.append(" != null");
    final JavaScript getIdForScriptWithResourceName = this.getScriptWithResourceName.append(".getAttribute('id')");
    final JavaScript setResourceNameForId = JavaScript.js("document.getElementById('{0}').setAttribute('resourceName', '{1}')");
    final JavaScript removeScript = JavaScript.js("selenium.doRemoveScript('{0}')");

    public void requireResource(String resourceName) {
        if (!this.containsScript(resourceName)) {
            this.loadScript(resourceName);
        } else {
            this.refreshScript(resourceName);
        }
    }

    private boolean containsScript(String resourceName) {
        return Boolean.valueOf(this.selenium.getEval(this.containsScriptWithResourceName.parametrize(StringEscapeUtils.escapeJavaScript((String)resourceName))));
    }

    private void loadScript(String resourceName) {
        JavaScript extension = JavaScript.fromResource(resourceName);
        String identification = extension.getIdentification();
        String escapedResourceName = StringEscapeUtils.escapeJavaScript((String)resourceName);
        this.selenium.addScript(extension);
        this.selenium.getEval(this.setResourceNameForId.parametrize(identification, escapedResourceName));
    }

    private void refreshScript(String resourceName) {
        JavaScript extension = JavaScript.fromResource(resourceName);
        String identification = extension.getIdentification();
        String escapedResourceName = StringEscapeUtils.escapeJavaScript((String)resourceName);
        String scriptId = this.selenium.getEval(this.getIdForScriptWithResourceName.parametrize(escapedResourceName));
        if (!scriptId.equals(identification)) {
            System.out.println("# Reloading extension: " + resourceName);
            this.selenium.getEval(this.removeScript.parametrize(scriptId));
            this.loadScript(resourceName);
        }
    }

    public void requireResources(List<String> resourceNames) {
        for (String resourceName : resourceNames) {
            this.requireResource(resourceName);
        }
    }

    public void registerCustomHandlers() {
        JavaScript registerCustomHandlers = JavaScript.js("currentTest.commandFactory.registerAll(selenium)");
        this.selenium.getEval(registerCustomHandlers);
    }
}

