/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.locator;

import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.locator.AbstractLocator;
import org.jboss.test.selenium.locator.Attribute;
import org.jboss.test.selenium.locator.AttributeLocator;
import org.jboss.test.selenium.locator.ElementLocationStrategy;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class DefaultAttributeLocator<E extends ElementLocator<E>>
extends AbstractLocator<AttributeLocator<E>>
implements AttributeLocator<E> {
    ElementLocator<E> elementLocator;
    Attribute attribute;

    public DefaultAttributeLocator(ElementLocator<E> elementLocator, Attribute attribute) {
        super("not-used");
        Validate.notNull((Object)attribute);
        this.elementLocator = elementLocator;
        this.attribute = attribute;
    }

    @Override
    public String getRawLocator() {
        return SimplifiedFormat.format("{0}@{1}", this.elementLocator.getRawLocator(), this.attribute.getAttributeName());
    }

    @Override
    public ElementLocationStrategy getLocationStrategy() {
        return this.elementLocator.getLocationStrategy();
    }

    @Override
    public ElementLocator<E> getAssociatedElement() {
        return this.elementLocator;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public AttributeLocator<E> format(Object ... args) {
        ElementLocator<E> derivedElementLocator = this.elementLocator.format(args);
        return new DefaultAttributeLocator<E>(derivedElementLocator, this.attribute);
    }
}

