/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.browser;

import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public enum BrowserType {
    FIREFOX,
    IEXPLORE,
    SAFARI,
    OPERA,
    GOOGLE_CHROME,
    KONQUEROR,
    MOCK;


    public static BrowserType parseType(String browserType) {
        String upperCased = browserType.toUpperCase();
        return BrowserType.valueOf(upperCased);
    }

    public static EnumSet<BrowserType> parseTypes(String browserTypesEnumeration) {
        HashSet<BrowserType> types = new HashSet<BrowserType>();
        for (String type : StringUtils.split((String)browserTypesEnumeration, (String)", ")) {
            if ("*".equals(type)) {
                return EnumSet.allOf(BrowserType.class);
            }
            types.add(BrowserType.parseType(type));
        }
        if (types.isEmpty()) {
            return EnumSet.noneOf(BrowserType.class);
        }
        return EnumSet.copyOf(types);
    }
}

