/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.AttributeLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class AttributePresent
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private AttributeLocator<?> attributeLocator;

    protected AttributePresent() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.attributeLocator);
        return this.selenium.isAttributePresent(this.attributeLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedElementLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAssociatedElement().getAsString());
        String escapedAttributeName = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAttribute().getAttributeName());
        return JavaScript.js(SimplifiedFormat.format("selenium.isAttributePresent('{0}', '{1}')", escapedElementLocator, escapedAttributeName));
    }

    public static AttributePresent getInstance() {
        return new AttributePresent();
    }

    public AttributePresent locator(AttributeLocator<?> attributeLocator) {
        Validate.notNull(attributeLocator);
        AttributePresent copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    private AttributePresent copy() {
        AttributePresent copy = new AttributePresent();
        copy.attributeLocator = this.attributeLocator;
        return copy;
    }
}

