/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.css.CssProperty;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class StyleEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private ElementLocator<?> elementLocator;
    private CssProperty cssProperty;
    private String value;

    protected StyleEquals() {
    }

    @Override
    public boolean isTrue() {
        this.validate();
        return this.selenium.getStyle(this.elementLocator, this.cssProperty).equals(this.value);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        this.validate();
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.getAsString());
        String escapedCssProperty = StringEscapeUtils.escapeJavaScript((String)this.cssProperty.getPropertyName());
        String escapedText = StringEscapeUtils.escapeJavaScript((String)this.value);
        return JavaScript.js(SimplifiedFormat.format("selenium.isElementPresent('{0}') && (selenium.getStyle('{0}', '{1}') == '{2}')", escapedLocator, escapedCssProperty, escapedText));
    }

    private void validate() {
        Validate.notNull(this.elementLocator);
        Validate.notNull((Object)this.cssProperty);
        Validate.notNull((Object)this.value);
    }

    public static StyleEquals getInstance() {
        return new StyleEquals();
    }

    public StyleEquals locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        StyleEquals copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    public StyleEquals property(CssProperty cssProperty) {
        Validate.notNull((Object)cssProperty);
        StyleEquals copy = this.copy();
        copy.cssProperty = cssProperty;
        return copy;
    }

    public StyleEquals value(String value) {
        Validate.notNull((Object)value);
        StyleEquals copy = this.copy();
        copy.value = value;
        return copy;
    }

    private StyleEquals copy() {
        StyleEquals copy = new StyleEquals();
        copy.elementLocator = this.elementLocator;
        copy.cssProperty = this.cssProperty;
        copy.value = this.value;
        return copy;
    }
}

