/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.logging.internal;

import java.util.ArrayList;
import org.jboss.tools.rsp.logging.internal.SLF4JLogReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGILogReaderInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(OSGILogReaderInitializer.class);
    private ServiceListener serviceListener = null;
    private SLF4JLogReader logReader = new SLF4JLogReader();
    private ServiceTracker<LogReaderService, LogReaderService> tracker;

    public ServiceListener getServiceListener() {
        if (this.serviceListener == null) {
            this.serviceListener = this.createServiceListener();
        }
        return this.serviceListener;
    }

    public void addServiceListener(BundleContext context) {
        String filter = "(objectclass=" + LogReaderService.class.getName() + ")";
        try {
            context.addServiceListener(this.getServiceListener(), filter);
        }
        catch (InvalidSyntaxException e) {
            LOG.error("error adding service listener: ", (Throwable)e);
        }
    }

    public void addLogListenerToServices(BundleContext context) {
        LogReaderService[] services = this.getAllReaders(context);
        int i = 0;
        while (i < services.length) {
            services[i].addLogListener((LogListener)this.logReader);
            ++i;
        }
    }

    public void removeLogListenerToServices(BundleContext context) {
        LogReaderService[] services = this.getAllReaders(context);
        int i = 0;
        while (i < services.length) {
            services[i].removeLogListener((LogListener)this.logReader);
            ++i;
        }
    }

    private LogReaderService[] getAllReaders(BundleContext context) {
        ServiceTracker<LogReaderService, LogReaderService> tracker = this.getTracker(context);
        ArrayList<LogReaderService> list = new ArrayList<LogReaderService>();
        Object[] currentReaders = tracker.getServices();
        if (currentReaders != null) {
            int index = 0;
            while (index < currentReaders.length) {
                LogReaderService reader = (LogReaderService)currentReaders[index];
                list.add(reader);
                ++index;
            }
        }
        return list.toArray(new LogReaderService[list.size()]);
    }

    private ServiceTracker<LogReaderService, LogReaderService> getTracker(BundleContext context) {
        if (this.tracker == null) {
            this.tracker = new ServiceTracker(context, LogReaderService.class.getName(), null);
            this.tracker.open();
        }
        return this.tracker;
    }

    public void dispose(BundleContext context) {
        this.removeLogListenerToServices(context);
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private ServiceListener createServiceListener() {
        return new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                ServiceReference ref = event.getServiceReference();
                if (ref == null) {
                    return;
                }
                Bundle bundle = ref.getBundle();
                if (bundle == null) {
                    return;
                }
                BundleContext context = bundle.getBundleContext();
                if (context == null) {
                    return;
                }
                LogReaderService reader = (LogReaderService)context.getService(ref);
                if (reader != null) {
                    if (event.getType() == 1) {
                        LOG.debug("adding a log listener to {}", (Object)reader);
                        reader.addLogListener((LogListener)OSGILogReaderInitializer.this.logReader);
                    } else if (event.getType() == 4) {
                        LOG.debug("removing a log listener from {}", (Object)reader);
                        reader.removeLogListener((LogListener)OSGILogReaderInitializer.this.logReader);
                    }
                }
            }
        };
    }

    public void init(BundleContext context) {
        this.addLogListenerToServices(context);
        this.addServiceListener(context);
    }
}

