/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.api;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.jboss.tools.rsp.api.dao.Attributes;
import org.jboss.tools.rsp.api.dao.ClientCapabilitiesRequest;
import org.jboss.tools.rsp.api.dao.CommandLineDetails;
import org.jboss.tools.rsp.api.dao.CreateServerResponse;
import org.jboss.tools.rsp.api.dao.DiscoveryPath;
import org.jboss.tools.rsp.api.dao.DownloadSingleRuntimeRequest;
import org.jboss.tools.rsp.api.dao.GetServerJsonResponse;
import org.jboss.tools.rsp.api.dao.JobHandle;
import org.jboss.tools.rsp.api.dao.JobProgress;
import org.jboss.tools.rsp.api.dao.LaunchAttributesRequest;
import org.jboss.tools.rsp.api.dao.LaunchParameters;
import org.jboss.tools.rsp.api.dao.ListDeployablesResponse;
import org.jboss.tools.rsp.api.dao.ListDeploymentOptionsResponse;
import org.jboss.tools.rsp.api.dao.ListDownloadRuntimeResponse;
import org.jboss.tools.rsp.api.dao.ListServerActionResponse;
import org.jboss.tools.rsp.api.dao.PublishServerRequest;
import org.jboss.tools.rsp.api.dao.ServerActionRequest;
import org.jboss.tools.rsp.api.dao.ServerAttributes;
import org.jboss.tools.rsp.api.dao.ServerBean;
import org.jboss.tools.rsp.api.dao.ServerCapabilitiesResponse;
import org.jboss.tools.rsp.api.dao.ServerDeployableReference;
import org.jboss.tools.rsp.api.dao.ServerHandle;
import org.jboss.tools.rsp.api.dao.ServerLaunchMode;
import org.jboss.tools.rsp.api.dao.ServerStartingAttributes;
import org.jboss.tools.rsp.api.dao.ServerState;
import org.jboss.tools.rsp.api.dao.ServerType;
import org.jboss.tools.rsp.api.dao.StartServerResponse;
import org.jboss.tools.rsp.api.dao.Status;
import org.jboss.tools.rsp.api.dao.StopServerAttributes;
import org.jboss.tools.rsp.api.dao.UpdateServerRequest;
import org.jboss.tools.rsp.api.dao.UpdateServerResponse;
import org.jboss.tools.rsp.api.dao.WorkflowResponse;

@JsonSegment(value="server")
public interface RSPServer {
    @JsonRequest
    public CompletableFuture<ServerCapabilitiesResponse> registerClientCapabilities(ClientCapabilitiesRequest var1);

    @JsonNotification
    public void shutdown();

    @JsonRequest
    public CompletableFuture<List<DiscoveryPath>> getDiscoveryPaths();

    @JsonRequest
    public CompletableFuture<List<ServerBean>> findServerBeans(DiscoveryPath var1);

    @JsonRequest
    public CompletableFuture<Status> addDiscoveryPath(DiscoveryPath var1);

    @JsonRequest
    public CompletableFuture<Status> removeDiscoveryPath(DiscoveryPath var1);

    @JsonRequest
    public CompletableFuture<List<ServerHandle>> getServerHandles();

    @JsonRequest
    public CompletableFuture<List<ServerType>> getServerTypes();

    @JsonRequest
    public CompletableFuture<Status> deleteServer(ServerHandle var1);

    @JsonRequest
    public CompletableFuture<Attributes> getRequiredAttributes(ServerType var1);

    @JsonRequest
    public CompletableFuture<Attributes> getOptionalAttributes(ServerType var1);

    @JsonRequest
    public CompletableFuture<CreateServerResponse> createServer(ServerAttributes var1);

    @JsonRequest
    public CompletableFuture<GetServerJsonResponse> getServerAsJson(ServerHandle var1);

    @JsonRequest
    public CompletableFuture<UpdateServerResponse> updateServer(UpdateServerRequest var1);

    @JsonRequest
    public CompletableFuture<List<ServerLaunchMode>> getLaunchModes(ServerType var1);

    @JsonRequest
    public CompletableFuture<Attributes> getRequiredLaunchAttributes(LaunchAttributesRequest var1);

    @JsonRequest
    public CompletableFuture<Attributes> getOptionalLaunchAttributes(LaunchAttributesRequest var1);

    @JsonRequest
    public CompletableFuture<CommandLineDetails> getLaunchCommand(LaunchParameters var1);

    @JsonRequest
    public CompletableFuture<Status> serverStartingByClient(ServerStartingAttributes var1);

    @JsonRequest
    public CompletableFuture<Status> serverStartedByClient(LaunchParameters var1);

    @JsonRequest
    public CompletableFuture<ServerState> getServerState(ServerHandle var1);

    @JsonRequest
    public CompletableFuture<StartServerResponse> startServerAsync(LaunchParameters var1);

    @JsonRequest
    public CompletableFuture<Status> stopServerAsync(StopServerAttributes var1);

    @JsonRequest
    public CompletableFuture<ListDeployablesResponse> getDeployables(ServerHandle var1);

    @JsonRequest
    public CompletableFuture<ListDeploymentOptionsResponse> listDeploymentOptions(ServerHandle var1);

    @JsonRequest
    public CompletableFuture<Status> addDeployable(ServerDeployableReference var1);

    @JsonRequest
    public CompletableFuture<Status> removeDeployable(ServerDeployableReference var1);

    @JsonRequest
    public CompletableFuture<Status> publish(PublishServerRequest var1);

    @JsonRequest
    public CompletableFuture<Status> publishAsync(PublishServerRequest var1);

    @JsonRequest
    public CompletableFuture<ListDownloadRuntimeResponse> listDownloadableRuntimes();

    @JsonRequest
    public CompletableFuture<WorkflowResponse> downloadRuntime(DownloadSingleRuntimeRequest var1);

    @JsonRequest
    public CompletableFuture<ListServerActionResponse> listServerActions(ServerHandle var1);

    @JsonRequest
    public CompletableFuture<WorkflowResponse> executeServerAction(ServerActionRequest var1);

    @JsonRequest
    public CompletableFuture<List<JobProgress>> getJobs();

    @JsonRequest
    public CompletableFuture<Status> cancelJob(JobHandle var1);
}

