/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.model.installer;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesModel;
import org.jboss.tools.rsp.runtime.core.model.IRuntimeInstaller;
import org.jboss.tools.rsp.runtime.core.model.installer.internal.BinaryInstaller;
import org.jboss.tools.rsp.runtime.core.model.installer.internal.ExtractionRuntimeInstaller;
import org.jboss.tools.rsp.runtime.core.model.installer.internal.JavaJarRuntimeInstaller;

public class RuntimesInstallerModel {
    private IDownloadRuntimesModel downloadRuntimesModel;
    private List<RuntimeInstallerWrapper> installers;

    public RuntimesInstallerModel(IDownloadRuntimesModel downloadRuntimesModel) {
        this.downloadRuntimesModel = downloadRuntimesModel;
    }

    public List<RuntimeInstallerWrapper> loadInstallers() {
        ArrayList<RuntimeInstallerWrapper> list = new ArrayList<RuntimeInstallerWrapper>();
        list.add(new RuntimeInstallerWrapper("archive", new ExtractionRuntimeInstaller(this.downloadRuntimesModel)));
        list.add(new RuntimeInstallerWrapper("binary", new BinaryInstaller(this.downloadRuntimesModel)));
        list.add(new RuntimeInstallerWrapper("installer-jar", new JavaJarRuntimeInstaller(this.downloadRuntimesModel)));
        return list;
    }

    public IRuntimeInstaller getRuntimeInstaller(String id) {
        if (this.installers == null) {
            this.installers = this.loadInstallers();
        }
        return this.installers.stream().filter(wrapper -> wrapper.getId().equals(id)).findFirst().map(RuntimeInstallerWrapper::getInstaller).orElse(null);
    }

    protected static class RuntimeInstallerWrapper {
        private String id;
        private IRuntimeInstaller installer;

        public RuntimeInstallerWrapper(String id, IRuntimeInstaller installer) {
            this.id = id;
            this.installer = installer;
        }

        public String getId() {
            return this.id;
        }

        public IRuntimeInstaller getInstaller() {
            return this.installer;
        }
    }
}

