/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.util.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IPath;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.Path;
import org.jboss.tools.rsp.eclipse.core.runtime.Status;
import org.jboss.tools.rsp.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.rsp.eclipse.osgi.util.NLS;
import org.jboss.tools.rsp.foundation.core.tasks.TaskModel;
import org.jboss.tools.rsp.foundation.core.transport.URLTransportCache;
import org.jboss.tools.rsp.runtime.core.extract.ExtractUtility;
import org.jboss.tools.rsp.runtime.core.extract.IOverwrite;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRuntimeOperationUtility {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadRuntimeOperationUtility.class);
    private IDownloadRuntimesModel model;
    private URLTransportCache cache;

    public DownloadRuntimeOperationUtility(IDownloadRuntimesModel model) {
        this.model = model;
    }

    protected File getNextUnusedFilename(File destination, String name) {
        String nameWithoutSuffix = null;
        nameWithoutSuffix = name.indexOf(46) == -1 ? name : (name.endsWith(".tar.gz") ? name.substring(0, name.length() - ".tar.gz".length()) : name.substring(0, name.lastIndexOf(46)));
        String suffix = name.substring(nameWithoutSuffix.length());
        int i = 1;
        String tmpName = null;
        File file = new File(destination, name);
        while (file.exists()) {
            tmpName = String.valueOf(nameWithoutSuffix) + "(" + i++ + ")" + suffix;
            file = new File(destination, tmpName);
        }
        return file;
    }

    private File getDestinationFile(String downloadDestinationPath, String urlString, boolean deleteOnExit) throws CoreException {
        File ret = null;
        try {
            URL url = new URL(urlString);
            String name = url.getPath();
            int slashIdx = name.lastIndexOf(47);
            if (slashIdx >= 0) {
                name = name.substring(slashIdx + 1);
            }
            File destination = new File(downloadDestinationPath);
            destination.mkdirs();
            ret = new File(destination, name);
            if (deleteOnExit) {
                ret = this.getNextUnusedFilename(destination, name);
            }
            if (deleteOnExit) {
                ret.deleteOnExit();
            }
            return ret;
        }
        catch (IOException e) {
            this.cancel(ret);
            Status s = new Status(4, "org.jboss.tools.rsp.runtime.core", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
    }

    private boolean cacheOutdated(File local, boolean deleteOnExit) {
        boolean download = true;
        long urlModified = 0L;
        if (!deleteOnExit) {
            long cacheModified = local.lastModified();
            download = cacheModified <= 0L || cacheModified != urlModified;
        }
        return download;
    }

    private long getRemoteURLModified(String urlString, String user, String pass, IProgressMonitor monitor) {
        monitor.beginTask("Checking remote timestamp", 100);
        long l = 0L;
        try {
            l = this.getCache().getLastModified(new URL(urlString), user, pass, monitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(100);
        monitor.done();
        return l;
    }

    private void validateInputs(String downloadDirectoryPath, String unzipDirectoryPath) throws CoreException {
        File downloadDirectory = new File(downloadDirectoryPath);
        downloadDirectory.mkdirs();
        if (!downloadDirectory.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", "The '" + downloadDirectory + "' is not a directory."));
        }
        File unzipDirectory = new File(unzipDirectoryPath);
        unzipDirectory.mkdirs();
        if (!unzipDirectory.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", "The '" + unzipDirectory + "' is not a directory."));
        }
    }

    public File download(String unzipDirectoryPath, String downloadDirectoryPath, String urlString, boolean deleteOnExit, String user, String pass, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Download runtime from url " + urlString, 500);
        File downloadedFile = null;
        try {
            this.validateInputs(downloadDirectoryPath, unzipDirectoryPath);
            File file = downloadedFile = this.downloadRemoteRuntime(downloadDirectoryPath, urlString, deleteOnExit, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 450));
            return file;
        }
        catch (CoreException ce) {
            if (!new File(unzipDirectoryPath).delete()) {
                LOG.debug("Unable to delete file: " + unzipDirectoryPath);
            }
            throw new CoreException((IStatus)new Status(ce.getStatus().getSeverity(), "org.jboss.tools.rsp.runtime.core", NLS.bind((String)"Error while retrieving runtime from {0}", (Object)urlString), (Throwable)ce));
        }
        finally {
            monitor.done();
        }
    }

    public IStatus downloadAndUnzip(String unzipDirectoryPath, String downloadDirectoryPath, String urlString, boolean deleteOnExit, String user, String pass, TaskModel tm, IProgressMonitor monitor) {
        monitor.beginTask("Configuring runtime from url " + urlString, 500);
        File downloadedFile = null;
        try {
            this.validateInputs(downloadDirectoryPath, unzipDirectoryPath);
            downloadedFile = this.downloadRemoteRuntime(downloadDirectoryPath, urlString, deleteOnExit, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 450));
        }
        catch (CoreException ce) {
            if (!new File(unzipDirectoryPath).delete()) {
                LOG.debug("Unable to delete file: " + unzipDirectoryPath);
            }
            return new Status(ce.getStatus().getSeverity(), "org.jboss.tools.rsp.runtime.core", NLS.bind((String)"Error while retrieving runtime from {0}", (Object)urlString), (Throwable)ce);
        }
        try {
            try {
                ExtractUtility extractUtil = new ExtractUtility(downloadedFile);
                IOverwrite ow = (IOverwrite)tm.getObject("dl.runtime.overwrite");
                if (ow == null) {
                    ow = this.createOverwriteFileQuery();
                }
                this.unzip(extractUtil, downloadedFile, unzipDirectoryPath, ow, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                String updatedRuntimeRoot = this.getUpdatedUnzipPath(extractUtil, unzipDirectoryPath, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                tm.putObject("dl.runtime.unzipped.home.dir", (Object)updatedRuntimeRoot);
            }
            catch (CoreException ce) {
                Status status = new Status(ce.getStatus().getSeverity(), "org.jboss.tools.rsp.runtime.core", NLS.bind((String)"Error while retrieving runtime from {0}", (Object)urlString), (Throwable)ce);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private File downloadRemoteRuntime(String destinationDirectory, String urlString, boolean deleteOnExit, String user, String pass, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)"Downloading {0}", (Object)urlString), 1000);
        File file = null;
        try {
            file = this.getDestinationFile(destinationDirectory, urlString, deleteOnExit);
            long urlModified = 0L;
            if (!deleteOnExit) {
                urlModified = this.getRemoteURLModified(urlString, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            }
            boolean download = this.cacheOutdated(file, deleteOnExit);
            IStatus result = Status.OK_STATUS;
            if (download) {
                result = this.downloadFileFromRemoteUrl(file, new URL(urlString), urlModified, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
            }
            if (monitor.isCanceled()) {
                Files.delete(file.toPath());
                throw new CoreException(this.cancel(file));
            }
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            this.cancel(file);
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", e.getMessage(), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void unzip(ExtractUtility util, File downloadedFile, String unzipDirectoryPath, IOverwrite overwriteQuery, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Unzipping " + downloadedFile.getAbsolutePath(), 1000);
        if (monitor.isCanceled()) {
            throw new CoreException(this.cancel(downloadedFile));
        }
        IStatus status = util.extract(new File(unzipDirectoryPath), overwriteQuery, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        if (monitor.isCanceled()) {
            throw new CoreException(this.cancel(downloadedFile));
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private IStatus cancel(File f) {
        if (f != null) {
            f.deleteOnExit();
            if (!f.delete()) {
                LOG.debug("Unable to delete file: " + f.getAbsolutePath());
            }
        }
        return Status.CANCEL_STATUS;
    }

    private IOverwrite createOverwriteFileQuery() {
        return file -> 0;
    }

    private String getUpdatedUnzipPath(ExtractUtility util, String unzipDirectoryPath, IProgressMonitor monitor) throws CoreException {
        try {
            File rootFile;
            String root = util.getExtractedRootFolder((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (root != null && (rootFile = new File(unzipDirectoryPath, root)).exists()) {
                unzipDirectoryPath = rootFile.getAbsolutePath();
            }
            String string = unzipDirectoryPath;
            return string;
        }
        catch (CoreException ce) {
            this.cancel(util.getOriginalFile());
            throw ce;
        }
        finally {
            monitor.done();
        }
    }

    private IStatus downloadFileFromRemoteUrl(File toFile, URL url, long remoteUrlModified, String user, String pass, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var9_9 = null;
        try (FileOutputStream out = new FileOutputStream(toFile);){
            IStatus result = null;
            InputStream override = this.createDownloadInputStream(url, user, pass);
            if (override == null) {
                result = this.getCache().download(toFile.getName(), url.toExternalForm(), user, pass, out, -1, monitor);
            } else {
                long cLength = this.getContentLength(url, user, pass);
                result = this.getCache().download(toFile.getName(), override, out, -1, cLength, monitor);
            }
            out.flush();
            if (remoteUrlModified > 0L && !toFile.setLastModified(remoteUrlModified)) {
                LOG.debug("Unable to set timestamp for " + toFile.getAbsolutePath());
            }
            if (result.isOK()) {
                this.getCache().addToCache(url.toString(), toFile);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected InputStream createDownloadInputStream(URL url, String user, String pass) {
        return null;
    }

    protected long getContentLength(URL url, String user, String pass) {
        return -1L;
    }

    protected File getCachedFileForURL(String url, String jobName, IProgressMonitor monitor) throws CoreException {
        if (this.getCache().isCacheOutdated(url, monitor)) {
            return this.cache.downloadAndCache(url, jobName, 10000, true, monitor);
        }
        return this.cache.getCachedFile(url);
    }

    private URLTransportCache getCache() {
        if (this.cache == null) {
            this.cache = this.getDefaultDownloadRuntimeCache();
        }
        return this.cache;
    }

    private final URLTransportCache getDefaultDownloadRuntimeCache() {
        File data = this.model.getDataLocation();
        File transportCache = new File(data, "runtimes");
        return URLTransportCache.getCache((IPath)new Path(transportCache.getAbsolutePath()));
    }
}

