/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.extract;

import java.io.File;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.Status;
import org.jboss.tools.rsp.runtime.core.extract.IOverwrite;
import org.jboss.tools.rsp.runtime.core.extract.internal.IExtractUtility;
import org.jboss.tools.rsp.runtime.core.extract.internal.UntarGZUtility;
import org.jboss.tools.rsp.runtime.core.extract.internal.UntarUtility;
import org.jboss.tools.rsp.runtime.core.extract.internal.UntarXZUtility;
import org.jboss.tools.rsp.runtime.core.extract.internal.UnzipUtility;

public class ExtractUtility {
    private static final String ZIP_SUFFIX = "zip";
    private static final String TAR_SUFFIX = "tar";
    private static final String TAR_GZ_SUFFIX = ".gz";
    private static final String TGZ_SUFFIX = ".tgz";
    private static final String TAR_XZ_SUFFIX = ".xz";
    public static final int FORMAT_UNKNOWN = -1;
    public static final int FORMAT_ZIP = 1;
    public static final int FORMAT_TAR = 2;
    public static final int FORMAT_TGZ = 3;
    public static final int FORMAT_XZ = 4;
    private final File file;
    private final IExtractUtility util;

    public ExtractUtility(File file) {
        this(file, -1);
    }

    public ExtractUtility(File file, int format) {
        this.file = file;
        this.util = -1 == format ? this.getUtil(file) : this.getUtil(file, format);
    }

    private IExtractUtility getUtil(File file, int format) {
        switch (format) {
            case 1: {
                return new UnzipUtility(file);
            }
            case 2: {
                return new UntarUtility(file);
            }
            case 3: {
                return new UntarGZUtility(file);
            }
            case 4: {
                return new UntarXZUtility(file);
            }
        }
        return null;
    }

    private IExtractUtility getUtil(File file) {
        String name = file.getName().toLowerCase();
        if (name.endsWith(ZIP_SUFFIX)) {
            return new UnzipUtility(file);
        }
        if (name.endsWith(TAR_SUFFIX)) {
            return new UntarUtility(file);
        }
        if (name.endsWith(TAR_GZ_SUFFIX) || name.endsWith(TGZ_SUFFIX)) {
            return new UntarGZUtility(file);
        }
        if (name.endsWith(TAR_XZ_SUFFIX)) {
            return new UntarXZUtility(file);
        }
        return null;
    }

    public File getOriginalFile() {
        return this.file;
    }

    public IStatus extract(File destination, IOverwrite overwriteQuery, IProgressMonitor monitor) {
        if (this.util != null) {
            try {
                return this.util.extract(destination, overwriteQuery, monitor);
            }
            catch (CoreException ce) {
                return new Status(4, "org.jboss.tools.rsp.runtime.core", "Error extracting file " + this.file.getAbsolutePath(), (Throwable)ce);
            }
        }
        return new Status(4, "org.jboss.tools.rsp.runtime.core", "Unable to discover how to extract file " + this.file.getAbsolutePath());
    }

    public String getExtractedRootFolder(IProgressMonitor monitor) throws CoreException {
        if (this.util != null) {
            return this.util.getRoot(monitor);
        }
        return null;
    }
}

