/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.model.installer.internal;

import java.io.InputStream;
import java.net.URL;
import org.jboss.tools.rsp.foundation.core.tasks.TaskModel;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimeConnectionFactory;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesModel;
import org.jboss.tools.rsp.runtime.core.util.internal.DownloadRuntimeOperationUtility;

public class DownloadRuntimeOperationUtilFactory {
    public static DownloadRuntimeOperationUtility createDownloadRuntimeOperationUtility(final TaskModel tm, IDownloadRuntimesModel downloadRuntimesModel) {
        final IDownloadRuntimeConnectionFactory fact = (IDownloadRuntimeConnectionFactory)tm.getObject("dl.runtime.connection.factory");
        if (fact == null) {
            return new DownloadRuntimeOperationUtility(downloadRuntimesModel){

                @Override
                protected long getContentLength(URL url, String user, String pass) {
                    Long expectedSize = (Long)tm.getObject("dl.runtime.size.expected");
                    if (expectedSize != null) {
                        return expectedSize;
                    }
                    return -1L;
                }
            };
        }
        return new DownloadRuntimeOperationUtility(downloadRuntimesModel){

            @Override
            protected InputStream createDownloadInputStream(URL url, String user, String pass) {
                return fact.createConnection(url, user, pass);
            }

            @Override
            protected long getContentLength(URL url, String user, String pass) {
                Long expectedSize;
                long ret = fact.getContentLength(url, user, pass);
                if (ret == -1L && (expectedSize = (Long)tm.getObject("dl.runtime.size.expected")) != null) {
                    return expectedSize;
                }
                return ret;
            }
        };
    }
}

