/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.secure.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.tools.rsp.secure.crypto.CryptoException;

public class CryptoUtils {
    private String algo;
    private String transformation;

    static {
        Security.setProperty("crypto.policy", "unlimited");
    }

    public CryptoUtils(String algo, String transformation) {
        this.algo = algo;
        this.transformation = transformation;
    }

    public byte[] keyTo16(byte[] bytes) {
        if (bytes.length < 16) {
            return this.padKey(bytes);
        }
        if (bytes.length == 16) {
            return bytes;
        }
        byte[] ret = new byte[16];
        System.arraycopy(bytes, 0, ret, 0, 16);
        return ret;
    }

    public byte[] padKey(byte[] bytes) {
        int mod = bytes.length % 16;
        int toPad = 16 - mod;
        byte[] ret = new byte[bytes.length + toPad];
        System.arraycopy(bytes, 0, ret, 0, bytes.length);
        int i = bytes.length;
        while (i < ret.length) {
            ret[i] = 126;
            ++i;
        }
        return ret;
    }

    public byte[] encrypt(byte[] key, byte[] plain) throws CryptoException {
        return this.doCrypto(1, key, plain);
    }

    public byte[] decrypt(byte[] key, byte[] encrypted) throws CryptoException {
        return this.doCrypto(2, key, encrypted);
    }

    public void encrypt(byte[] key, File inputFile, File outputFile) throws CryptoException {
        try {
            byte[] inputBytes = this.getBytesFromFile(inputFile);
            byte[] encrypted = this.doCrypto(1, key, inputBytes);
            this.writeBytesToFile(outputFile, encrypted);
        }
        catch (IOException ioe) {
            throw new CryptoException("Error encrypting/decrypting file", ioe);
        }
    }

    public void decrypt(byte[] key, File inputFile, File outputFile) throws CryptoException {
        try {
            byte[] inputBytes = this.getBytesFromFile(inputFile);
            byte[] encrypted = this.doCrypto(2, key, inputBytes);
            this.writeBytesToFile(outputFile, encrypted);
        }
        catch (IOException ioe) {
            throw new CryptoException("Error encrypting/decrypting file", ioe);
        }
    }

    public byte[] getBytesFromFile(File f) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(f);){
            byte[] inputBytes = new byte[(int)f.length()];
            if (inputStream.read(inputBytes) > 0) {
                return inputBytes;
            }
            return new byte[0];
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void writeBytesToFile(File outputFile, byte[] bytes) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            outputStream.write(bytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private byte[] doCrypto(int cipherMode, byte[] key, byte[] inputBytes) throws CryptoException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, this.algo);
            Cipher cipher = Cipher.getInstance(this.transformation);
            cipher.init(cipherMode, secretKey);
            byte[] outputBytes = cipher.doFinal(inputBytes);
            return outputBytes;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Error encrypting/decrypting file", ex);
        }
    }
}

