/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.logging;

import ch.qos.logback.classic.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLevelInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(LogLevelInitializer.class);

    public static void initLogLevel() {
        String sysprop = System.getProperty("rsp.log.level");
        if (sysprop != null) {
            try {
                int i = Integer.parseInt(sysprop);
                LogLevelInitializer.setLogLevel(i);
            }
            catch (NumberFormatException nfe) {
                LOG.error("Unable to read system property for log level (rsp.log.level)", (Throwable)nfe);
            }
        }
    }

    private static void setLogLevel(int level) {
        Logger root = LoggerFactory.getLogger((String)"ROOT");
        if (level == 1) {
            ((ch.qos.logback.classic.Logger)root).setLevel(Level.ERROR);
        } else if (level == 2) {
            ((ch.qos.logback.classic.Logger)root).setLevel(Level.WARN);
        } else if (level == 3) {
            ((ch.qos.logback.classic.Logger)root).setLevel(Level.INFO);
        } else if (level == 4) {
            ((ch.qos.logback.classic.Logger)root).setLevel(Level.DEBUG);
        }
    }
}

