/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.extract.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.Status;
import org.jboss.tools.rsp.eclipse.osgi.util.NLS;
import org.jboss.tools.rsp.runtime.core.extract.IOverwrite;
import org.jboss.tools.rsp.runtime.core.extract.internal.IExtractUtility;

public class UntarUtility
implements IExtractUtility {
    private static final String SEPARATOR = "/";
    protected File file;
    private String discoveredRoot = null;
    private boolean rootEntryImpossible = false;

    public UntarUtility(File file) {
        this.file = file;
    }

    @Override
    public IStatus extract(File dest, IOverwrite overwriteQuery, IProgressMonitor monitor) throws CoreException {
        String possibleRoot = null;
        try {
            dest.mkdir();
            TarArchiveInputStream tarIn = this.getTarArchiveInputStream(this.file);
            TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
            while (tarEntry != null) {
                String name = tarEntry.getName();
                File destPath = new File(dest, name);
                if (tarEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    if (!destPath.getParentFile().exists()) {
                        destPath.getParentFile().mkdirs();
                    }
                    if (!destPath.createNewFile()) {
                        String msg = NLS.bind((String)"Error extracting runtime: Could not create file {0}", (Object)destPath.toString());
                        throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", 0, msg, null));
                    }
                    byte[] btoRead = new byte[1024];
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));){
                        int length = 0;
                        while ((length = tarIn.read(btoRead)) != -1) {
                            bout.write(btoRead, 0, length);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                possibleRoot = this.checkForPossibleRootEntry(possibleRoot, name);
                tarEntry = tarIn.getNextTarEntry();
            }
            tarIn.close();
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", 0, NLS.bind((String)"Error extracting runtime {0}", (Object)ioe.getLocalizedMessage()), (Throwable)ioe));
        }
        this.discoveredRoot = possibleRoot;
        return Status.OK_STATUS;
    }

    protected String checkForPossibleRootEntry(String possibleRoot, String name) {
        if (!this.rootEntryImpossible && this.discoveredRoot == null) {
            if (name == null || name.isEmpty() || name.startsWith(SEPARATOR) || name.indexOf(SEPARATOR) == -1) {
                this.rootEntryImpossible = true;
                return null;
            }
            String directory = name.substring(0, name.indexOf(SEPARATOR));
            if (possibleRoot == null) {
                return directory;
            }
            if (!directory.equals(possibleRoot)) {
                this.rootEntryImpossible = true;
                return null;
            }
        }
        return possibleRoot;
    }

    protected TarArchiveInputStream getTarArchiveInputStream(File file) throws IOException {
        return new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
    }

    @Override
    public String getRoot(IProgressMonitor monitor) throws CoreException {
        if (this.discoveredRoot != null) {
            return this.discoveredRoot;
        }
        if (this.rootEntryImpossible) {
            return null;
        }
        return null;
    }
}

