/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import org.jboss.tools.rsp.api.dao.DownloadRuntimeDescription;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.Status;
import org.jboss.tools.rsp.eclipse.core.runtime.SubMonitor;
import org.jboss.tools.rsp.eclipse.osgi.util.NLS;

public class DownloadRuntime
extends DownloadRuntimeDescription {
    private static final int BUFFER_SIZE = 8192;

    public DownloadRuntime(String effectiveId, String name, String version, String dlUrl) {
        this.setId(effectiveId);
        this.setName(name);
        this.setVersion(version);
        this.setUrl(dlUrl);
        this.setProperties(new HashMap());
    }

    public void setProperty(String key, String value) {
        if (this.getProperties() != null) {
            this.getProperties().put(key, value);
        }
    }

    public String getProperty(String key) {
        if (this.getProperties() != null) {
            return (String)this.getProperties().get(key);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLicense(IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                if (this.getLicenseURL() == null) {
                    return null;
                }
                URL url = new URL(this.getLicenseURL());
                InputStream in = url.openStream();
                this.copyWithSize(in, out, monitor, 0);
                return new String(out.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", 0, NLS.bind((String)"Unable to fetch license for {0}", (Object)e.getLocalizedMessage()), (Throwable)e));
        }
    }

    private void copyWithSize(InputStream in, OutputStream out, IProgressMonitor monitor, int size) throws IOException {
        byte[] buffer = new byte[8192];
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        int r = in.read(buffer);
        while (r >= 0) {
            out.write(buffer, 0, r);
            progress.worked(r);
            r = in.read(buffer);
        }
    }

    public DownloadRuntimeDescription toDao() {
        DownloadRuntimeDescription ret = new DownloadRuntimeDescription();
        ret.setDisclaimer(this.isDisclaimer());
        ret.setHumanUrl(this.getHumanUrl());
        ret.setId(this.getId());
        ret.setInstallationMethod(this.getInstallationMethod());
        ret.setName(this.getName());
        ret.setProperties(this.getProperties());
        ret.setVersion(this.getVersion());
        ret.setSize(this.getSize());
        ret.setLicenseURL(this.getLicenseURL());
        ret.setUrl(this.getUrl());
        return ret;
    }
}

