/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.stacks.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.jdf.stacks.model.Archetype;
import org.jboss.jdf.stacks.model.ArchetypeVersion;
import org.jboss.jdf.stacks.model.Runtime;
import org.jboss.jdf.stacks.model.Stacks;

public class StacksUtil {
    private static final Map<String, String> RUNTIMES_MAP;
    public static final String EAP_TYPE = "EAP";
    public static final String AS_TYPE = "AS";

    static {
        HashMap<String, String> serverIdMap = new HashMap<String, String>();
        serverIdMap.put("org.jboss.ide.eclipse.as.runtime.eap.60", "jbosseap6runtime");
        serverIdMap.put("org.jboss.ide.eclipse.as.runtime.71", "jboss-as711runtime");
        serverIdMap.put("org.jboss.ide.eclipse.as.runtime.70", "jboss-as702runtime-web");
        RUNTIMES_MAP = Collections.unmodifiableMap(serverIdMap);
    }

    private StacksUtil() {
    }

    public static Archetype getArchetype(String archetypeId, Stacks fromStacks) {
        if (fromStacks == null || archetypeId == null) {
            return null;
        }
        for (Archetype a : fromStacks.getAvailableArchetypes()) {
            if (!archetypeId.equals(a.getId())) continue;
            return a;
        }
        return null;
    }

    public static List<Runtime> getCompatibleRuntimes(Archetype archetype, Stacks fromStacks, String ... runtimeTypes) {
        if (fromStacks == null || archetype == null) {
            return Collections.emptyList();
        }
        ArrayList<Runtime> runtimes = new ArrayList<Runtime>();
        for (Runtime runtime : StacksUtil.getRuntimes(fromStacks, runtimeTypes)) {
            List<ArchetypeVersion> versions = StacksUtil.getCompatibleArchetypeVersions(archetype, runtime);
            if (versions.isEmpty()) continue;
            runtimes.add(runtime);
        }
        return Collections.unmodifiableList(runtimes);
    }

    public static List<Runtime> getRuntimes(Stacks fromStacks, String ... runtimeTypes) {
        if (fromStacks == null) {
            return Collections.emptyList();
        }
        ArrayList<Runtime> runtimes = new ArrayList<Runtime>();
        List<String> runtimeTypeFilter = null;
        if (runtimeTypes != null && runtimeTypes.length > 0) {
            runtimeTypeFilter = Arrays.asList(runtimeTypes);
        }
        for (Runtime runtime : fromStacks.getAvailableRuntimes()) {
            String runtimeType;
            if (runtimeTypeFilter != null && !runtimeTypeFilter.contains(runtimeType = StacksUtil.getRuntimeType(runtime))) continue;
            runtimes.add(runtime);
        }
        return Collections.unmodifiableList(runtimes);
    }

    public static Runtime getRuntime(Stacks fromStacks, String runtimeId) {
        if (fromStacks == null || runtimeId == null) {
            return null;
        }
        for (Runtime runtime : fromStacks.getAvailableRuntimes()) {
            if (!runtimeId.equals(runtime.getId())) continue;
            return runtime;
        }
        return null;
    }

    public static Runtime getRuntimeFromWtpId(Stacks fromStacks, String wtpRuntimeId) {
        if (fromStacks == null || wtpRuntimeId == null) {
            return null;
        }
        for (Runtime runtime : fromStacks.getAvailableRuntimes()) {
            Properties p = runtime.getLabels();
            if (p == null || !wtpRuntimeId.equals(p.get("wtp-runtime-id"))) continue;
            return runtime;
        }
        String stacksRuntimeId = RUNTIMES_MAP.get(wtpRuntimeId);
        return StacksUtil.getRuntime(fromStacks, stacksRuntimeId);
    }

    public static List<Runtime> getCompatibleServerRuntimes(Archetype archetype, Stacks fromStacks) {
        return StacksUtil.getCompatibleRuntimes(archetype, fromStacks, AS_TYPE, EAP_TYPE);
    }

    public static List<ArchetypeVersion> getCompatibleArchetypeVersions(Archetype archetype, Runtime runtime) {
        if (archetype == null || runtime == null) {
            return Collections.emptyList();
        }
        ArrayList<ArchetypeVersion> compatibleVersions = new ArrayList<ArchetypeVersion>();
        List versions = runtime.getArchetypes();
        if (versions != null && !versions.isEmpty()) {
            String bestVersion = archetype.getRecommendedVersion();
            for (ArchetypeVersion v : versions) {
                if (!archetype.equals(v.getArchetype())) continue;
                if (v.getVersion().equals(bestVersion)) {
                    compatibleVersions.add(0, v);
                    continue;
                }
                compatibleVersions.add(v);
            }
        }
        return Collections.unmodifiableList(compatibleVersions);
    }

    public static boolean isRuntimeCompatible(ArchetypeVersion archetypeVersion, Runtime runtime) {
        if (archetypeVersion == null || runtime == null) {
            return false;
        }
        List versions = runtime.getArchetypes();
        return versions != null && versions.contains(archetypeVersion);
    }

    public static boolean isEnterprise(Runtime runtime) {
        return EAP_TYPE.equals(StacksUtil.getRuntimeType(runtime));
    }

    public static String getRuntimeType(Runtime runtime) {
        if (runtime == null) {
            return null;
        }
        Properties p = runtime.getLabels();
        return (String)p.get("runtime-type");
    }

    public static ArchetypeVersion getDefaultArchetypeVersion(String archetypeId, Stacks fromStacks) {
        if (fromStacks == null || archetypeId == null) {
            return null;
        }
        Archetype targetArchetype = StacksUtil.getArchetype(archetypeId, fromStacks);
        return StacksUtil.getDefaultArchetypeVersion(targetArchetype, fromStacks);
    }

    public static ArchetypeVersion getDefaultArchetypeVersion(Archetype archetype, Stacks fromStacks) {
        if (fromStacks == null || archetype == null) {
            return null;
        }
        List versions = fromStacks.getAvailableArchetypeVersions();
        for (ArchetypeVersion version : versions) {
            if (!archetype.equals(version.getArchetype()) || !version.getVersion().equals(archetype.getRecommendedVersion())) continue;
            return version;
        }
        return versions.isEmpty() ? null : (ArchetypeVersion)versions.get(0);
    }
}

