/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.model.installer.internal;

import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.rsp.foundation.core.tasks.TaskModel;
import org.jboss.tools.rsp.runtime.core.model.DownloadRuntime;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesModel;
import org.jboss.tools.rsp.runtime.core.model.IRuntimeInstaller;
import org.jboss.tools.rsp.runtime.core.model.installer.internal.DownloadRuntimeOperationUtilFactory;
import org.jboss.tools.rsp.runtime.core.util.internal.DownloadRuntimeOperationUtility;

public class ExtractionRuntimeInstaller
implements IRuntimeInstaller {
    public static final String ID = "archive";
    private IDownloadRuntimesModel downloadRuntimesModel;

    public ExtractionRuntimeInstaller(IDownloadRuntimesModel downloadRuntimesModel) {
        this.downloadRuntimesModel = downloadRuntimesModel;
    }

    @Override
    public IStatus installRuntime(DownloadRuntime downloadRuntime, String unzipDirectory, String downloadDirectory, boolean deleteOnExit, TaskModel taskModel, IProgressMonitor monitor) {
        String user = (String)taskModel.getObject("dl.runtime.username");
        String pass = (String)taskModel.getObject("dl.runtime.password");
        monitor.beginTask("Download '" + downloadRuntime.getName() + "' ...", 100);
        monitor.worked(1);
        DownloadRuntimeOperationUtility opUtil = DownloadRuntimeOperationUtilFactory.createDownloadRuntimeOperationUtility(taskModel, this.downloadRuntimesModel);
        return opUtil.downloadAndUnzip(unzipDirectory, downloadDirectory, this.getDownloadUrl(downloadRuntime, taskModel), deleteOnExit, user, pass, taskModel, (IProgressMonitor)new SubProgressMonitor(monitor, 99));
    }

    private String getDownloadUrl(DownloadRuntime downloadRuntime, TaskModel taskModel) {
        if (downloadRuntime != null) {
            String dlUrl = downloadRuntime.getUrl();
            if (dlUrl == null) {
                return (String)taskModel.getObject("dl.runtime.url");
            }
            return dlUrl;
        }
        return null;
    }
}

