/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.stacks.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.jdf.stacks.client.DefaultStacksClientConfiguration;
import org.jboss.jdf.stacks.client.StacksClient;
import org.jboss.jdf.stacks.client.StacksClientConfiguration;
import org.jboss.jdf.stacks.client.messages.StacksMessages;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.jdf.stacks.parser.Parser;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IPath;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.Path;
import org.jboss.tools.rsp.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.rsp.foundation.core.transport.URLTransportCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StacksManager {
    private static final int DOWNLOAD_STACKS_TIMEOUT = 5000;
    private static final Logger LOG = LoggerFactory.getLogger(StacksManager.class);
    @Deprecated
    private static final String STACKS_URL_PROPERTY = "org.jboss.examples.stacks.url";
    private static final String URL_PROPERTY_STACKS = "org.jboss.tools.stacks.url_stacks";
    private static final String URL_PROPERTY_PRESTACKS = "org.jboss.tools.stacks.url_prestacks";
    private static final String STACKS_URL = System.getProperty("org.jboss.tools.stacks.url_stacks", System.getProperty("org.jboss.examples.stacks.url", System.getProperty("jdf.stacks.client.repo", StacksManager.getStacksDefaultUrlFromJar())));
    private static final String PRESTACKS_URL = System.getProperty("org.jboss.tools.stacks.url_prestacks", System.getProperty("jdf.prestacks.client.repo", StacksManager.getPreStacksDefaultUrlFromJar()));
    private File dataFolder;
    private URLTransportCache cache;

    @Deprecated
    private StacksManager() {
    }

    public StacksManager(File dataFolder) {
        this.dataFolder = dataFolder;
    }

    public Stacks getStacks(IProgressMonitor monitor) {
        Stacks[] all = this.getStacks("Fetching JBoss Stacks", monitor, StacksType.STACKS_TYPE);
        if (all != null && all.length > 0) {
            return all[0];
        }
        return null;
    }

    public Stacks[] getStacks(String jobName, IProgressMonitor monitor, StacksType ... types) {
        if (types == null) {
            return new Stacks[0];
        }
        LOG.trace("Request received for {} stacks types.", (Object)types.length);
        ArrayList<Stacks> ret = new ArrayList<Stacks>(types.length);
        monitor.beginTask(jobName, types.length * 100);
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case STACKS_TYPE: {
                    LOG.trace("Loading Stacks Model from {}", (Object)STACKS_URL);
                    Stacks s = this.getStacks(STACKS_URL, jobName, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (s == null && !monitor.isCanceled()) {
                        LOG.warn("Stacks from {} can not be read, using client mechanism instead", (Object)STACKS_URL);
                        s = this.getDefaultStacksFromClient((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    }
                    if (s == null) break;
                    ret.add(s);
                    break;
                }
                case PRESTACKS_TYPE: {
                    LOG.trace("Loading Stacks Model from {}", (Object)PRESTACKS_URL);
                    Stacks s2 = this.getStacks(PRESTACKS_URL, jobName, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    if (s2 == null) break;
                    ret.add(s2);
                    break;
                }
            }
            ++i;
        }
        monitor.done();
        return ret.toArray(new Stacks[ret.size()]);
    }

    public Stacks getStacks(String url, IProgressMonitor monitor) {
        return this.getStacksFromURL(url, url, monitor);
    }

    public Stacks getStacks(String url, String jobName, IProgressMonitor monitor) {
        return this.getStacksFromURL(url, jobName, monitor);
    }

    protected Stacks getStacksFromURL(String url, String jobName, IProgressMonitor monitor) {
        Stacks stacks = null;
        try {
            LOG.trace("Locating or downloading file for {}", (Object)url);
            File f = this.getCachedFileForURL(url, jobName, monitor);
            return this.getStacksFromFile(f);
        }
        catch (Exception e) {
            LOG.error("Can't access or parse  " + url, (Throwable)e);
            return stacks;
        }
    }

    protected Stacks getStacksFromFile(File f) throws IOException {
        if (f != null && f.exists()) {
            LOG.trace("Local file for url exists");
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream fis = new FileInputStream(f);){
                Parser p = new Parser();
                return p.parse((InputStream)fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private Stacks getDefaultStacksFromClient(IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            StacksClient client = new StacksClient((StacksClientConfiguration)new DefaultStacksClientConfiguration(), (StacksMessages)new JBTStacksMessages());
            return StacksManager.runWithTimeout(5000L, () -> ((StacksClient)client).getStacks());
        }
        return null;
    }

    public static <R> R runWithTimeout(long millisTimeout, Callable<R> callable) {
        ExecutorService singleThreadExecutor = Executors.newFixedThreadPool(1);
        Future<R> future = singleThreadExecutor.submit(callable);
        try {
            R r = future.get(millisTimeout, TimeUnit.MILLISECONDS);
            return r;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            singleThreadExecutor.shutdown();
        }
        return null;
    }

    protected File getCachedFileForURL(String url, String jobName, IProgressMonitor monitor) throws CoreException {
        URLTransportCache c = this.getCache();
        if (c == null) {
            return null;
        }
        if (c.isCacheOutdated(url, monitor)) {
            return c.downloadAndCache(url, jobName, 10000, true, monitor);
        }
        return c.getCachedFile(url);
    }

    private URLTransportCache getCache() {
        if (this.cache == null) {
            if (this.dataFolder != null) {
                File stacks = new File(this.dataFolder, "stacks");
                this.cache = URLTransportCache.getCache((IPath)new Path(stacks.getAbsolutePath()));
            } else {
                try {
                    File tmpDir = Files.createTempDirectory("rsp-stacks", new FileAttribute[0]).toFile();
                    tmpDir.mkdirs();
                    File stacks = new File(this.dataFolder, "stacks");
                    this.cache = URLTransportCache.getCache((IPath)new Path(stacks.getAbsolutePath()));
                }
                catch (IOException ioe) {
                    LOG.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
        return this.cache;
    }

    private static String getStacksDefaultUrlFromJar() {
        return StacksManager.getUrlFromJar("jdf.stacks.client.repo");
    }

    private static String getPreStacksDefaultUrlFromJar() {
        return StacksManager.getUrlFromJar("jdf.prestacks.client.repo");
    }

    private static String getUrlFromJar(String prop) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = StacksManager.class.getResourceAsStream("/org/jboss/jdf/stacks/client/config.properties");){
                Properties p = new Properties();
                p.load(is);
                return p.getProperty(prop);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.warn("Can't read stacks url from the stacks-client.jar", (Throwable)e);
            return null;
        }
    }

    private static class JBTStacksMessages
    implements StacksMessages {
        private JBTStacksMessages() {
        }

        public void showDebugMessage(String arg0) {
            LOG.trace(arg0);
        }

        public void showInfoMessage(String arg0) {
            LOG.info(arg0);
        }

        public void showErrorMessage(String arg0) {
            LOG.error(arg0);
        }

        public void showErrorMessageWithCause(String arg0, Throwable t) {
            LOG.error(arg0, t);
        }

        public void showWarnMessage(String arg0) {
            LOG.warn(arg0);
        }
    }

    public static enum StacksType {
        STACKS_TYPE,
        PRESTACKS_TYPE;

    }
}

