/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.extract.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.Status;
import org.jboss.tools.rsp.runtime.core.extract.IOverwrite;
import org.jboss.tools.rsp.runtime.core.extract.internal.IExtractUtility;

public class UnzipUtility
implements IExtractUtility {
    private static final String EXTRACTING = "Extracting ...";
    private static final String SEPARATOR = "/";
    private File file;
    private String discoveredRoot = null;
    private boolean rootEntryImpossible = false;

    public UnzipUtility(File file) {
        this.file = file;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IStatus extract(File destination, IOverwrite overwriteQuery, IProgressMonitor monitor) {
        if (this.file == null || !this.file.exists()) {
            return new Status(4, "org.jboss.tools.rsp.runtime.core", "Error opening zip file: " + (this.file == null ? "File not provided." : String.valueOf(this.file.getAbsolutePath()) + "; File does not exist."));
        }
        possibleRoot = null;
        overwrite = 2;
        destination.mkdirs();
        try {
            var6_6 = null;
            var7_9 = null;
            try {
                zipFile = new ZipFile(this.file);
                try {
                    destinationCanon = destination.getCanonicalPath();
                    entries = zipFile.entries();
                    monitor.beginTask("Extracting ...", zipFile.size());
                    while (true) {
                        block34: {
                            monitor.worked(1);
                            if (monitor.isCanceled() || overwrite == 4) {
                                return Status.CANCEL_STATUS;
                            }
                            entry = entries.nextElement();
                            entryName = entry.getName();
                            entryFile = new File(destination, entryName);
                            monitor.subTask(entry.getName());
                            if (!entryFile.getCanonicalPath().startsWith(destinationCanon)) break block34;
                            if (overwrite != 1 && overwrite != 3 && entryFile.exists() && (overwrite = overwriteQuery.overwrite(entryFile)) == 4) {
                                return Status.CANCEL_STATUS;
                            }
                            if (!entryFile.exists() || overwrite == 0 || overwrite == 1) {
                                this.createEntry(monitor, zipFile, entry, entryFile);
                            }
                            if (this.rootEntryImpossible) break;
                            if (this.discoveredRoot != null) break;
                            if (entryName == null || entryName.isEmpty() || entryName.startsWith("/") || entryName.indexOf("/") == -1) {
                                this.rootEntryImpossible = true;
                                possibleRoot = null;
                            }
                            directory = entryName.substring(0, entryName.indexOf("/"));
                            if (possibleRoot == null) {
                                possibleRoot = directory;
                            }
                            if (!directory.equals(possibleRoot)) {
                                this.rootEntryImpossible = true;
                                possibleRoot = null;
                                return possibleRoot;
                            }
                            break;
                        }
                        break;
                    }
                }
                finally {
                    if (entries.hasMoreElements()) ** continue;
                }
            }
            catch (Throwable var7_10) {
                if (var6_6 == null) {
                    var6_6 = var7_10;
                } else if (var6_6 != var7_10) {
                    var6_6.addSuppressed(var7_10);
                }
                throw var6_6;
            }
        }
        catch (IOException e) {
            isZipped = false;
            try {
                zipFile = null;
                var9_17 = null;
                try {
                    test = new ZipInputStream(new FileInputStream(this.file));
                    try {
                        isZipped = test.getNextEntry() != null;
                    }
                    finally {
                        if (test != null) {
                            test.close();
                        }
                    }
                }
                catch (Throwable var9_18) {
                    if (zipFile == null) {
                        zipFile = var9_18;
                    } else if (zipFile != var9_18) {
                        zipFile.addSuppressed(var9_18);
                    }
                    throw zipFile;
                }
            }
            catch (IOException zipFile) {
                // empty catch block
            }
            msg = "Error opening zip file " + this.file.getAbsolutePath();
            if (!isZipped) {
                msg = String.valueOf(msg) + ";  file may not be a properly formated zip file.";
            }
            return new Status(4, "org.jboss.tools.rsp.runtime.core", msg, (Throwable)e);
        }
        this.discoveredRoot = possibleRoot;
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createEntry(IProgressMonitor monitor, ZipFile zipFile, ZipEntry entry, File entryFile) throws IOException {
        monitor.setTaskName(EXTRACTING + entry.getName());
        if (entry.isDirectory()) {
            entryFile.mkdirs();
            return;
        }
        entryFile.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            InputStream in = zipFile.getInputStream(entry);
            try {
                try (FileOutputStream out = new FileOutputStream(entryFile);){
                    this.copy(in, out);
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[16384];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getRoot(IProgressMonitor monitor) throws CoreException {
        if (this.discoveredRoot != null) {
            return this.discoveredRoot;
        }
        if (this.rootEntryImpossible) {
            return null;
        }
        monitor.beginTask("Locating root folder", 100);
        String root = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(this.file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                if (entries.hasMoreElements()) {
                }
                return root;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException ioe) {
            Status s = new Status(4, "org.jboss.tools.rsp.runtime.core", ioe.getLocalizedMessage(), (Throwable)ioe);
            throw new CoreException((IStatus)s);
        }
    }
}

