/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;

public class SocketLauncher<T>
implements Launcher<T> {
    private final Launcher<T> launcher;
    private Future<Void> startListeningResult;
    private Socket socket;

    public SocketLauncher(Object localService, Class<T> remoteInterface, Socket socket) throws IOException {
        this.launcher = Launcher.createLauncher((Object)localService, remoteInterface, (InputStream)socket.getInputStream(), (OutputStream)socket.getOutputStream());
        this.socket = socket;
    }

    public SocketLauncher(Object localService, Class<T> remoteInterface, Socket socket, PrintWriter tracing) throws IOException {
        Launcher<T> launcherTmp = this.createLauncher(this.createBuilder(remoteInterface), localService, remoteInterface, socket.getInputStream(), socket.getOutputStream(), tracing);
        this.launcher = launcherTmp;
        this.socket = socket;
    }

    public SocketLauncher(Object localService, Class<T> remoteInterface, Socket socket, Launcher.Builder<T> b, PrintWriter tracing) throws IOException {
        Launcher<T> launcherTmp = this.createLauncher(b, localService, remoteInterface, socket.getInputStream(), socket.getOutputStream(), tracing);
        this.launcher = launcherTmp;
        this.socket = socket;
    }

    protected Launcher.Builder<T> createBuilder(Class<T> remoteInterface) {
        return new Launcher.Builder();
    }

    protected Launcher<T> createLauncher(Launcher.Builder<T> builder, Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, PrintWriter tracing) {
        return builder.setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).traceMessages(tracing).create();
    }

    public CompletableFuture<Void> startListening() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        return CompletableFuture.runAsync(() -> {
            try {
                this.startListeningResult = this.launcher.startListening();
                this.startListeningResult.get();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            service.shutdown();
        }, service);
    }

    public T getRemoteProxy() {
        return (T)this.launcher.getRemoteProxy();
    }

    public RemoteEndpoint getRemoteEndpoint() {
        return this.launcher.getRemoteEndpoint();
    }

    public void close() {
        if (this.startListeningResult != null) {
            this.startListeningResult.cancel(true);
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Future<Void> getStartListeningResult() {
        return this.startListeningResult;
    }
}

