/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IJvmFacade;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.ui.JvmMonitorPreferences;
import org.jboss.tools.jmx.local.internal.Activator;
import org.jboss.tools.jmx.local.internal.JVMConnectionProvider;
import org.jboss.tools.jmx.local.internal.JvmKey;

public class JvmConnectionWrapper
implements IConnectionWrapper,
IAdaptable,
IJvmFacade {
    private IActiveJvm activeJvm;
    private JvmKey key;
    private Root root;
    private List<Runnable> afterLoadRunnables = new ArrayList<Runnable>();
    private IProgressMonitor progressMonitor;

    public JvmConnectionWrapper(IActiveJvm vm) {
        this.activeJvm = vm;
        this.progressMonitor = null;
        this.key = this.getJvmKey(vm);
    }

    public String toString() {
        return this.getName();
    }

    public IActiveJvm getActiveJvm() {
        return this.activeJvm;
    }

    public void setActiveJvm(IActiveJvm activeJvm) {
        if (this.activeJvm != activeJvm) {
            IActiveJvm oldJvm = this.activeJvm;
            this.activeJvm = activeJvm;
            this.key = this.getJvmKey(activeJvm);
            if (oldJvm != null) {
                try {
                    oldJvm.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public Object getAdapter(Class adapter) {
        ITabbedPropertySheetPageContributor contributor = new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.jboss.tools.jmx.jvmmonitor.ui.JvmExplorer";
            }
        };
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage(contributor);
        }
        if (adapter == ITabbedPropertySheetPageContributor.class) {
            return contributor;
        }
        return null;
    }

    protected void addOnLoadRunnable(Runnable runnable) {
        this.afterLoadRunnables.add(runnable);
    }

    public MBeanServerConnection getConnection() {
        return this.activeJvm.getMBeanServer().getConnection();
    }

    public synchronized void connect() throws IOException {
        if (!this.activeJvm.isConnected() && this.activeJvm.isConnectionSupported()) {
            int updatePeriod = JvmMonitorPreferences.getJvmUpdatePeriod();
            try {
                this.activeJvm.connect(updatePeriod);
            }
            catch (JvmCoreException e) {
                e.printStackTrace();
            }
            this.fireConnectionChanged();
        }
    }

    public synchronized void disconnect() throws IOException {
        this.root = null;
        this.activeJvm.disconnect();
        this.fireConnectionChanged();
    }

    public boolean isConnected() {
        return this.activeJvm.isConnected();
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadRoot() {
        if (this.isConnected() && this.root == null) {
            try {
                if (this.progressMonitor == null) {
                    this.progressMonitor = new NullProgressMonitor();
                }
                this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this, (IProgressMonitor)this.progressMonitor);
                for (Runnable task : this.afterLoadRunnables) {
                    task.run();
                }
                this.afterLoadRunnables.clear();
            }
            catch (Throwable e) {
                Activator.pluginLog().logWarning("Failed to load JMX tree for " + this + ". " + e, e);
            }
            this.progressMonitor = null;
        }
    }

    public void run(IJMXRunnable runnable) throws JMXException {
        try {
            runnable.run(this.getConnection());
        }
        catch (Exception ce) {
            Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRunningJMXCode, (Throwable)ce);
            throw new JMXException((IStatus)s);
        }
    }

    public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
        this.run(runnable);
    }

    public boolean canControl() {
        return true;
    }

    protected void fireConnectionChanged() {
        JVMConnectionProvider provider = (JVMConnectionProvider)this.getProvider();
        provider.fireChanged(this);
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.jboss.tools.jmx.local.JVMConnectionProvider");
    }

    public String getName() {
        return this.activeJvm == null ? "null" : this.activeJvm.getMainClass();
    }

    public Properties getAgentProperties() {
        return new Properties();
    }

    public Map<String, String> getSystemProperties() {
        return System.getenv();
    }

    public void loadRoot(IProgressMonitor monitor) throws CoreException {
        this.progressMonitor = monitor;
        this.loadRoot();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JvmConnectionWrapper && this.key.equals(((JvmConnectionWrapper)obj).getKey());
    }

    protected JvmKey getKey() {
        return this.key;
    }

    private JvmKey getJvmKey(IActiveJvm jvm) {
        int pid = jvm.getPid();
        String hostName = jvm.getHost().getName();
        return new JvmKey(hostName, pid, jvm);
    }
}

