/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlotCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.RuntimeClasspathCache;
import org.osgi.framework.BundleContext;

public class ClasspathCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.jboss.ide.eclipse.as.classpath.core";
    private static ClasspathCorePlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)RuntimeClasspathCache.getInstance());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)RuntimeClasspathCache.getInstance());
    }

    public static ClasspathCorePlugin getDefault() {
        return plugin;
    }

    public static void log(String msg, Throwable e) {
        ILog log = ClasspathCorePlugin.getDefault().getLog();
        Status status = new Status(4, PLUGIN_ID, msg, e);
        log.log((IStatus)status);
    }

    public static void clearCachedClasspathEntries(IRuntimeType rt) {
        if (rt != null) {
            IRuntime[] allRuntimes = ServerCore.getRuntimes();
            IRuntimeType rtt = null;
            int i = 0;
            while (i < allRuntimes.length) {
                rtt = allRuntimes[i].getRuntimeType();
                if (rtt != null && rtt.getId().equals(rt.getId())) {
                    RuntimeClasspathCache.getInstance().cacheEntries(allRuntimes[i], null);
                    ModuleSlotCache.getInstance().clearRuntimeModuleSlots(allRuntimes[i]);
                }
                ++i;
            }
        }
    }
}

