/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.ejb3;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.internal.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerConstants;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class EJB3ClasspathContainer
implements IClasspathContainer,
IJBossServerConstants {
    public static final String CONTAINER_ID = "org.jboss.ide.eclipse.as.classpath.core.ejb3.classpathContainer";
    public static final String DESCRIPTION = Messages.EJB3ClasspathContainer_ejb3_description;
    public static final QualifiedName JBOSS_EJB3_CONFIGURATION = new QualifiedName("org.jboss.ide.eclipse.ejb3.wizards.core.classpath", "jboss-ejb3-configuration");
    protected IJavaProject javaProject;
    protected IJBossServer jbossServer;
    protected IPath path;
    protected IPath configPath = new Path("");
    protected IPath homePath = null;

    public EJB3ClasspathContainer(IPath path, IJavaProject project) {
        IProject p;
        this.path = path;
        this.javaProject = project;
        String configName = path.segment(1);
        IProject iProject = p = project == null ? null : project.getProject();
        if (configName == null && p != null && p.exists() && p.isOpen()) {
            configName = this.findLegacyConfigName(project);
        }
        IServer foundServer = this.findServer(configName);
        this.jbossServer = ServerConverter.getJBossServer((IServer)foundServer);
        if (this.jbossServer != null) {
            try {
                this.homePath = this.jbossServer.getServer().getRuntime().getLocation();
                this.configPath = new Path(this.jbossServer.getConfigDirectory());
            }
            catch (Exception e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.classpath.core", Messages.EJB3ClasspathContainer_could_not_determine_home, (Throwable)e);
                ClasspathCorePlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    private String findLegacyConfigName(IJavaProject project) {
        if (project == null) {
            return null;
        }
        String configName = null;
        try {
            configName = project.getProject().getPersistentProperty(JBOSS_EJB3_CONFIGURATION);
            if (configName != null) {
                project.getProject().setPersistentProperty(JBOSS_EJB3_CONFIGURATION, null);
            }
        }
        catch (CoreException coreException) {}
        return configName;
    }

    private IServer findServer(String serverName) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getName().equals(serverName)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }

    public String getDescription() {
        return Messages.EJB3ClasspathContainer_ejb30_description;
    }

    public IJBossServer getJBossServer() {
        return this.jbossServer;
    }

    public void setJBossServer(IJBossServer jbossServer) {
        this.jbossServer = jbossServer;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] ret = new IClasspathEntry[]{};
        if (this.jbossServer != null) {
            try {
                String id = this.jbossServer.getServer().getServerType().getRuntimeType().getId();
                if (id.equals("org.jboss.ide.eclipse.as.runtime.40")) {
                    ret = EJB3ClasspathContainer.get40Jars(this.homePath, this.configPath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.42")) {
                    ret = EJB3ClasspathContainer.get42Jars(this.homePath, this.configPath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.50")) {
                    ret = EJB3ClasspathContainer.get50Jars(this.homePath, this.configPath, true, true);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.51")) {
                    ret = EJB3ClasspathContainer.get51Jars(this.homePath, this.configPath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.eap.43")) {
                    ret = EJB3ClasspathContainer.get42Jars(this.homePath, this.configPath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.60")) {
                    ret = EJB3ClasspathContainer.get60Jars(this.homePath, this.configPath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.eap.50")) {
                    ret = EJB3ClasspathContainer.get50Jars(this.homePath, this.configPath, false, false);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.70")) {
                    ret = EJB3ClasspathContainer.get70Jars(this.homePath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.71")) {
                    ret = EJB3ClasspathContainer.get70Jars(this.homePath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.wildfly.80")) {
                    ret = EJB3ClasspathContainer.getEap61Jars(this.homePath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.eap.50")) {
                    ret = EJB3ClasspathContainer.get70Jars(this.homePath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.eap.60")) {
                    ret = EJB3ClasspathContainer.get70Jars(this.homePath);
                } else if (id.equals("org.jboss.ide.eclipse.as.runtime.eap.61")) {
                    ret = EJB3ClasspathContainer.getEap61Jars(this.homePath);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return ret;
    }

    public static IClasspathEntry[] get40Jars(IPath homePath, IPath configPath) throws FileNotFoundException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPath deploy = configPath.append("deploy");
        IPath deployer = deploy.append("ejb3.deployer");
        IPath aopDeployer = deploy.append("jboss-aop-jdk50.deployer");
        list.add(EJB3ClasspathContainer.getEntry(deployer.append("jboss-ejb3x.jar")));
        list.add(EJB3ClasspathContainer.getEntry(deployer.append("jboss-ejb3.jar")));
        list.add(EJB3ClasspathContainer.getEntry(deployer.append("jboss-annotations-ejb3.jar")));
        list.add(EJB3ClasspathContainer.getEntry(aopDeployer.append("jboss-aop-jdk50.jar")));
        list.add(EJB3ClasspathContainer.getEntry(aopDeployer.append("jboss-aspect-library-jdk50.jar")));
        list.add(EJB3ClasspathContainer.getEntry(homePath.append("client").append("hibernate-client.jar")));
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    public static IClasspathEntry[] get42Jars(IPath homePath, IPath configPath) throws FileNotFoundException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPath deploy = configPath.append("deploy");
        IPath deployer = deploy.append("ejb3.deployer");
        IPath aopDeployer = deploy.append("jboss-aop-jdk50.deployer");
        IPath client = homePath.append("client");
        list.add(EJB3ClasspathContainer.getEntry(configPath.append("lib").append("jboss-ejb3x.jar")));
        list.add(EJB3ClasspathContainer.getEntry(deployer.append("jboss-ejb3.jar")));
        list.add(EJB3ClasspathContainer.getEntry(deployer.append("jboss-annotations-ejb3.jar")));
        list.add(EJB3ClasspathContainer.getEntry(aopDeployer.append("jboss-aop-jdk50.jar")));
        list.add(EJB3ClasspathContainer.getEntry(aopDeployer.append("jboss-aspect-library-jdk50.jar")));
        list.add(EJB3ClasspathContainer.getEntry(homePath.append("client").append("hibernate-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("ejb3-persistence.jar")));
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected static IClasspathEntry[] get50Jars(IPath homePath, IPath configPath, boolean includeEJB3Proxy, boolean includeIIOP) throws FileNotFoundException {
        IPath deployers = configPath.append("deployers");
        IPath deployer = deployers.append("ejb3.deployer");
        IPath aopDeployer = deployers.append("jboss-aop-jboss5.deployer");
        IPath client = homePath.append("client");
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.add(EJB3ClasspathContainer.getEntry(aopDeployer.append("jboss-aspect-library.jar")));
        list.add(EJB3ClasspathContainer.getEntry(deployer.append("jboss-ejb3-deployer.jar")));
        if (includeIIOP) {
            list.add(EJB3ClasspathContainer.getEntry(deployer.append("jboss-ejb3-iiop.jar")));
        }
        list.add(EJB3ClasspathContainer.getEntry(client.append("ejb3-persistence.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-common-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-core-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-ext-api-impl.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-ext-api.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-proxy-clustered-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-security-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(homePath.append("client").append("hibernate-annotations.jar")));
        if (includeEJB3Proxy) {
            list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-proxy-client.jar")));
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected static IClasspathEntry[] get51Jars(IPath homePath, IPath configPath) throws FileNotFoundException {
        return EJB3ClasspathContainer.get50Jars(homePath, configPath, false, true);
    }

    protected static IClasspathEntry[] get60Jars(IPath homePath, IPath configPath) throws FileNotFoundException {
        IPath deployers = configPath.append("deployers");
        IPath aopDeployer = deployers.append("jboss-aop-jboss5.deployer");
        IPath client = homePath.append("client");
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.add(EJB3ClasspathContainer.getEntry(aopDeployer.append("jboss-aop-aspects.jar")));
        list.add(EJB3ClasspathContainer.getEntry(aopDeployer.append("jboss-as-aspects-jboss-aspect-library.jar")));
        list.add(EJB3ClasspathContainer.getEntry(deployers.append("jboss-ejb3-endpoint-deployer.jar")));
        list.add(EJB3ClasspathContainer.getEntry(deployers.append("jboss-ejb3-metrics-deployer.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-common-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-core-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-ext-api-impl.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-ext-api.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-proxy-spi-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-proxy-impl-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-proxy-clustered-client.jar")));
        list.add(EJB3ClasspathContainer.getEntry(client.append("jboss-ejb3-security-client.jar")));
        if (homePath.append("client").append("hibernate-annotations.jar").toFile().exists()) {
            list.add(EJB3ClasspathContainer.getEntry(homePath.append("client").append("hibernate-annotations.jar")));
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected static IClasspathEntry[] get70Jars(IPath homePath) throws FileNotFoundException {
        return EJB3ClasspathContainer.get70JarsFromBase(homePath.append("modules"));
    }

    protected static IClasspathEntry[] getEap61Jars(IPath homePath) throws FileNotFoundException {
        return EJB3ClasspathContainer.get70JarsFromBase(homePath.append("modules").append("system").append("layers").append("base"));
    }

    protected static IClasspathEntry[] get70JarsFromBase(IPath base) throws FileNotFoundException {
        IPath apiFolder = base.append("javax").append("ejb").append("api").append("main");
        IPath jbossEjb3Folder = base.append("org").append("jboss").append("ejb3").append("main");
        IPath jbossASEjb3Folder = base.append("org").append("jboss").append("as").append("ejb3").append("main");
        IPath api = EJB3ClasspathContainer.findJarFile(apiFolder);
        IPath jbossEjb3 = EJB3ClasspathContainer.findJarFile(jbossEjb3Folder);
        IPath jbossASEjb3 = EJB3ClasspathContainer.findJarFile(jbossASEjb3Folder);
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        if (api != null) {
            list.add(EJB3ClasspathContainer.getEntry(api));
        }
        if (jbossEjb3 != null) {
            list.add(EJB3ClasspathContainer.getEntry(jbossEjb3));
        }
        if (jbossASEjb3 != null) {
            list.add(EJB3ClasspathContainer.getEntry(jbossASEjb3));
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected static IPath findJarFile(IPath folder) {
        String[] names = folder.toFile().list();
        int i = 0;
        while (i < names.length) {
            if (names[i].endsWith(".jar")) {
                return folder.append(names[i]);
            }
            ++i;
        }
        return null;
    }

    protected static IClasspathEntry getEntry(IPath path) throws FileNotFoundException {
        if (!path.toFile().exists()) {
            throw new FileNotFoundException();
        }
        return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path).getClasspathEntry();
    }
}

