/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.jboss.ide.eclipse.archives.ui.NodeContribution;
import org.jboss.ide.eclipse.archives.ui.actions.NewArchiveAction;

public class ExtensionManager {
    public static final String NODE_POPUP_MENUS_EXTENSION_ID = "org.jboss.ide.eclipse.archives.ui.nodePopupMenus";
    public static final String NEW_PACKAGE_ACTIONS_EXTENSION_ID = "org.jboss.ide.eclipse.archives.ui.newArchiveActions";
    private NewArchiveAction[] newArchiveActions;
    private NodeContribution[] nodeContributions;
    private static ArrayList<ILabelProvider> labelProviders = new ArrayList();

    public NewArchiveAction[] getNewArchiveActions() {
        if (this.newArchiveActions == null) {
            this.newArchiveActions = ExtensionManager.findNewArchiveActions();
        }
        return this.newArchiveActions;
    }

    public NodeContribution[] getNodeContributions() {
        if (this.nodeContributions == null) {
            this.nodeContributions = ExtensionManager.findNodePopupMenuContributions();
        }
        return this.nodeContributions;
    }

    public static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static NodeContribution[] findNodePopupMenuContributions() {
        ArrayList<NodeContribution> contributions = new ArrayList<NodeContribution>();
        IExtension[] extensions = ExtensionManager.findExtension(NODE_POPUP_MENUS_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                NodeContribution tmp = new NodeContribution(elements[j]);
                if (tmp.getActionDelegate() != null) {
                    contributions.add(tmp);
                }
                ++j;
            }
            ++i;
        }
        return contributions.toArray(new NodeContribution[contributions.size()]);
    }

    public static NewArchiveAction[] findNewArchiveActions() {
        ArrayList<NewArchiveAction> contributions = new ArrayList<NewArchiveAction>();
        IExtension[] extensions = ExtensionManager.findExtension(NEW_PACKAGE_ACTIONS_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                NewArchiveAction tmp = new NewArchiveAction(elements[j]);
                if (tmp.getAction() != null) {
                    contributions.add(tmp);
                }
                ++j;
            }
            ++i;
        }
        return contributions.toArray(new NewArchiveAction[contributions.size()]);
    }

    public static void addLabelProvider(ILabelProvider p) {
        if (!labelProviders.contains(p)) {
            labelProviders.add(p);
        }
    }

    public static void removeLabelProvider(ILabelProvider p) {
        labelProviders.remove(p);
    }

    public static ILabelProvider findLabelProvider(Object element) {
        for (ILabelProvider l : labelProviders) {
            if (l.getText(element) == null) continue;
            return l;
        }
        return null;
    }
}

