/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.providers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.build.SaveArchivesJob;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveFileSetImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveFolderImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveImpl;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.ExtensionManager;
import org.jboss.ide.eclipse.archives.ui.NodeContribution;
import org.jboss.ide.eclipse.archives.ui.PackagesUIPlugin;
import org.jboss.ide.eclipse.archives.ui.actions.BuildAction;
import org.jboss.ide.eclipse.archives.ui.actions.NewArchiveAction;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;
import org.jboss.ide.eclipse.archives.ui.views.ProjectArchivesCommonView;
import org.jboss.ide.eclipse.archives.ui.wizards.FilesetWizard;
import org.jboss.ide.eclipse.archives.ui.wizards.NewJARWizard;

public class ArchivesActionProvider
extends CommonActionProvider {
    public static final String NEW_PACKAGE_MENU_ID = "org.jboss.ide.eclipse.archives.ui.newPackageMenu";
    public static final String NODE_CONTEXT_MENU_ID = "org.jboss.ide.eclipse.archives.ui.nodeContextMenu";
    public static final String NEW_PACKAGE_ADDITIONS = "newPackageAdditions";
    public static final String INITIAL_SEPARATOR_ID = "org.jboss.ide.eclipse.archives.ui.providers.initialSeparator";
    public static final String END_ADD_CHILD_SEPARATOR_ID = "org.jboss.ide.eclipse.archives.ui.providers.endAddChildSeparator";
    private static final String DELETE_NODE_PERMISSION_TOGGLE = "ArchivesActionProvider.DeleteNodePreferenceKey";
    private MenuManager newPackageManager;
    private NodeContribution[] nodePopupMenuContributions;
    private NewArchiveAction[] newPackageActions;
    private Action editAction;
    private Action deleteAction;
    private Action newFolderAction;
    private Action newFilesetAction;
    private Action buildAction;
    private ICommonViewerSite site;
    private KeyListener deleteKeyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127) {
                ArchivesActionProvider.this.deleteSelectedNodes();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    public void init(ICommonActionExtensionSite aSite) {
        this.newPackageActions = ExtensionManager.findNewArchiveActions();
        this.nodePopupMenuContributions = ExtensionManager.findNodePopupMenuContributions();
        Arrays.sort(this.nodePopupMenuContributions);
        this.site = aSite.getViewSite();
        this.createActions();
        this.newPackageManager = new MenuManager(ArchivesUIMessages.ProjectPackagesView_newPackageMenu_label, NEW_PACKAGE_MENU_ID);
        Control viewerControl = aSite.getStructuredViewer().getControl();
        String siteId = aSite.getViewSite().getId();
        if ("org.jboss.ide.eclipse.archives.ui.ProjectArchivesView".equals(siteId)) {
            viewerControl.addKeyListener(this.deleteKeyListener);
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        if (this.getContext() != null) {
            this.enableBuildAction((IAction)this.buildAction, this.getContext().getSelection());
        } else {
            this.buildAction.setEnabled(false);
        }
        this.menuAboutToShow2(manager);
    }

    public void menuAboutToShow2(IMenuManager manager) {
        if (this.site == null || this.site.getAdapter(IViewSite.class) == null) {
            return;
        }
        this.addNewPackageActions((IMenuManager)this.newPackageManager);
        IStructuredSelection selection = ArchivesActionProvider.getSelection(this.site);
        if (selection != null && !selection.isEmpty()) {
            Object element = selection.getFirstElement();
            if (element instanceof IProject || element instanceof ArchivesContentProviderDelegate.WrappedProject) {
                manager.add((IContributionItem)this.newPackageManager);
                manager.add((IAction)this.buildAction);
                this.buildAction.setText(ArchivesUIMessages.ProjectPackagesView_buildProjectAction_label);
            } else if (element instanceof IArchiveNode) {
                Separator s;
                IArchiveNode node = (IArchiveNode)element;
                if (manager.find(INITIAL_SEPARATOR_ID) == null) {
                    s = new Separator(INITIAL_SEPARATOR_ID);
                    s.setVisible(false);
                    manager.add((IContributionItem)s);
                }
                if (manager.find(END_ADD_CHILD_SEPARATOR_ID) == null) {
                    s = new Separator(END_ADD_CHILD_SEPARATOR_ID);
                    s.setVisible(false);
                    manager.add((IContributionItem)s);
                }
                if (node instanceof INamedContainerArchiveNode) {
                    manager.insertAfter(INITIAL_SEPARATOR_ID, (IAction)this.newFilesetAction);
                    manager.insertAfter(INITIAL_SEPARATOR_ID, (IAction)this.newFolderAction);
                    manager.insertAfter(INITIAL_SEPARATOR_ID, (IContributionItem)this.newPackageManager);
                    manager.insertBefore(END_ADD_CHILD_SEPARATOR_ID, (IContributionItem)new Separator(END_ADD_CHILD_SEPARATOR_ID));
                }
                if (node.getNodeType() == 0 && node instanceof ArchiveImpl) {
                    this.editAction.setText(ArchivesUIMessages.ProjectPackagesView_editPackageAction_label);
                    this.deleteAction.setText(ArchivesUIMessages.ProjectPackagesView_deletePackageAction_label);
                    this.editAction.setImageDescriptor(ArchivesSharedImages.getImageDescriptor("icons/jar_src_obj.gif"));
                    this.buildAction.setText(ArchivesUIMessages.ProjectPackagesView_buildArchiveAction_label);
                    manager.insertAfter(END_ADD_CHILD_SEPARATOR_ID, (IAction)this.buildAction);
                    manager.add((IAction)this.editAction);
                    manager.add((IAction)this.deleteAction);
                } else if (node.getNodeType() == 3 && node instanceof ArchiveFolderImpl) {
                    this.editAction.setText(ArchivesUIMessages.ProjectPackagesView_editFolderAction_label);
                    this.deleteAction.setText(ArchivesUIMessages.ProjectPackagesView_deleteFolderAction_label);
                    this.editAction.setImageDescriptor(ArchivesActionProvider.platformDescriptor("IMG_OBJ_FOLDER"));
                    manager.add((IAction)this.editAction);
                    manager.add((IAction)this.deleteAction);
                } else if (node.getNodeType() == 2 && node instanceof ArchiveFileSetImpl) {
                    this.editAction.setText(ArchivesUIMessages.ProjectPackagesView_editFilesetAction_label);
                    this.deleteAction.setText(ArchivesUIMessages.ProjectPackagesView_deleteFilesetAction_label);
                    ImageDescriptor id = ArchivesSharedImages.getImageDescriptor("icons/multiple_files.gif");
                    this.editAction.setImageDescriptor(id);
                    manager.add((IAction)this.editAction);
                    manager.add((IAction)this.deleteAction);
                }
                this.addContextMenuContributions(node, manager);
            }
        } else {
            ProjectArchivesCommonView v = ProjectArchivesCommonView.getInstance();
            if (v != null && v.getCurrentProject() != null) {
                manager.add((IContributionItem)this.newPackageManager);
            }
        }
    }

    protected void createActions() {
        this.newFolderAction = new Action(ArchivesUIMessages.ProjectPackagesView_newFolderAction_label, ArchivesActionProvider.platformDescriptor("IMG_OBJ_FOLDER")){

            public void run() {
                ArchivesActionProvider.this.createFolder();
            }
        };
        this.newFilesetAction = new Action(ArchivesUIMessages.ProjectPackagesView_newFilesetAction_label, ArchivesSharedImages.getImageDescriptor("icons/multiple_files.gif")){

            public void run() {
                ArchivesActionProvider.this.createFileset();
            }
        };
        this.deleteAction = new Action(ArchivesUIMessages.ProjectPackagesView_deletePackageAction_label, ArchivesActionProvider.platformDescriptor("IMG_TOOL_DELETE")){

            public void run() {
                ArchivesActionProvider.this.deleteSelectedNodes();
            }
        };
        this.editAction = new Action(ArchivesUIMessages.ProjectPackagesView_editPackageAction_label, ArchivesSharedImages.getImageDescriptor("icons/jar_src_obj.gif")){

            public void run() {
                ArchivesActionProvider.this.editSelectedNode();
            }
        };
        this.buildAction = new Action(ArchivesUIMessages.BuildArchivesNode, ArchivesSharedImages.getImageDescriptor("icons/build_packages.gif")){

            public void run() {
                new BuildAction().run(ArchivesActionProvider.getSelectedObject(ArchivesActionProvider.this.site));
            }
        };
    }

    private void enableBuildAction(IAction action, ISelection selection) {
        Object selected = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IResource res;
            Object o = ((IStructuredSelection)selection).getFirstElement();
            if (o instanceof ArchivesContentProviderDelegate.WrappedProject) {
                o = ((ArchivesContentProviderDelegate.WrappedProject)o).getElement();
            }
            if (o instanceof IAdaptable && (res = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
                selected = res.getProject();
            }
            if (o instanceof IArchiveNode) {
                selected = o;
            }
            boolean enabled = selected instanceof IArchiveNode || ArchivesModel.instance().canReregister(((IProject)selected).getLocation());
            action.setEnabled(enabled);
        }
    }

    private void addContextMenuContributions(final IArchiveNode context, IMenuManager mgr) {
        int i = 0;
        while (i < this.nodePopupMenuContributions.length) {
            final NodeContribution contribution = this.nodePopupMenuContributions[i];
            if (contribution.getActionDelegate().isEnabledFor(context)) {
                Action action = new Action(){

                    public String getId() {
                        return contribution.getId();
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return contribution.getIcon();
                    }

                    public String getText() {
                        return contribution.getLabel();
                    }

                    public void run() {
                        contribution.getActionDelegate().run(context);
                    }
                };
                mgr.add((IAction)action);
            }
            ++i;
        }
    }

    private void addNewPackageActions(IMenuManager manager) {
        manager.removeAll();
        int i = 0;
        while (i < this.newPackageActions.length) {
            NewArchiveAction action = this.newPackageActions[i];
            ActionWrapper wrapped = new ActionWrapper(action);
            wrapped.selectionChanged(ArchivesActionProvider.getSelection(this.site));
            manager.add((IAction)wrapped);
            ++i;
        }
    }

    private void createFolder() {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                IArchiveNode selected = ArchivesActionProvider.getSelectedNode(ArchivesActionProvider.this.site);
                boolean folderExists = false;
                IArchiveNode[] folders = selected.getChildren(3);
                int i = 0;
                while (i < folders.length) {
                    IArchiveFolder folder = (IArchiveFolder)folders[i];
                    if (folder.getName().equals(newText)) {
                        folderExists = true;
                        break;
                    }
                    ++i;
                }
                if (folderExists) {
                    return NLS.bind((String)ArchivesUIMessages.ProjectPackagesView_createFolderDialog_warnFolderExists, (Object)newText);
                }
                if ("".equals(newText)) {
                    return ArchivesUIMessages.ProjectPackagesView_createFolderDialog_blank;
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), ArchivesUIMessages.ProjectPackagesView_createFolderDialog_title, ArchivesUIMessages.ProjectPackagesView_createFolderDialog_message, "", validator);
        int response = dialog.open();
        if (response == 0) {
            String[] folderPaths = dialog.getValue().split("[\\\\/]");
            IArchiveNode selected = ArchivesActionProvider.getSelectedNode(this.site);
            IArchiveFolder current = null;
            IArchiveFolder temp = null;
            int i = folderPaths.length - 1;
            while (i >= 0) {
                temp = ArchivesCore.getInstance().getNodeFactory().createFolder();
                temp.setName(folderPaths[i]);
                if (current == null) {
                    current = temp;
                } else {
                    temp.addChild((IArchiveNode)current);
                    current = temp;
                }
                --i;
            }
            selected.addChild(current);
            new SaveArchivesJob(selected.getProjectPath()).schedule();
        }
    }

    private void createFileset() {
        IArchiveNode selected = ArchivesActionProvider.getSelectedNode(this.site);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new FilesetWizard(null, selected));
        dialog.open();
    }

    private void editSelectedNode() {
        IArchiveNode node = ArchivesActionProvider.getSelectedNode(this.site);
        if (node != null) {
            if (node.getNodeType() == 2 && node instanceof IArchiveStandardFileSet) {
                IArchiveStandardFileSet fileset = (IArchiveStandardFileSet)node;
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new FilesetWizard(fileset, node.getParent()));
                dialog.open();
            } else if (node.getNodeType() == 0 && node instanceof IArchive) {
                IArchive pkg = (IArchive)node;
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new NewJARWizard(pkg));
                dialog.open();
            } else if (node.getNodeType() == 3 && node instanceof IArchiveFolder) {
                IArchiveFolder folder = (IArchiveFolder)node;
                InputDialog dialog = new InputDialog(this.getShell(), ArchivesUIMessages.ProjectPackagesView_createFolderDialog_title, ArchivesUIMessages.ProjectPackagesView_createFolderDialog_message, folder.getName(), null);
                int response = dialog.open();
                if (response == 0) {
                    folder.setName(dialog.getValue());
                    new SaveArchivesJob(folder.getProjectPath()).schedule();
                }
            }
        }
    }

    private void deleteSelectedNodes() {
        IArchiveNode[] node = ArchivesActionProvider.getSelectedNodes(this.site);
        if (node != null && node.length > 0 && this.approveDeletion(node)) {
            ArrayList<IPath> paths = new ArrayList<IPath>();
            int i = 0;
            while (i < node.length) {
                IArchiveNode parent = node[i].getParent();
                parent.removeChild(node[i]);
                if (!paths.contains(parent.getProjectPath())) {
                    paths.add(parent.getProjectPath());
                }
                ++i;
            }
            Iterator pit = paths.iterator();
            while (pit.hasNext()) {
                new SaveArchivesJob((IPath)pit.next()).schedule();
            }
        }
    }

    private boolean approveDeletion(IArchiveNode[] node) {
        if (node != null) {
            IPreferenceStore store = PackagesUIPlugin.getDefault().getPreferenceStore();
            String current = store.getString(DELETE_NODE_PERMISSION_TOGGLE);
            boolean doNotPrompt = Boolean.parseBoolean(current);
            if (doNotPrompt) {
                return true;
            }
            MessageDialogWithToggle d = MessageDialogWithToggle.openYesNoQuestion((Shell)this.site.getShell(), (String)ArchivesUIMessages.deleteNodeMBTitle, (String)ArchivesUIMessages.deleteNodeMBDesc, (String)ArchivesUIMessages.deleteNodeMBToggle, (boolean)false, (IPreferenceStore)store, (String)DELETE_NODE_PERMISSION_TOGGLE);
            int ret = d.getReturnCode();
            boolean toggle = d.getToggleState();
            if (ret == 2) {
                store.setValue(DELETE_NODE_PERMISSION_TOGGLE, new Boolean(toggle).toString());
                try {
                    ((ScopedPreferenceStore)store).save();
                }
                catch (IOException iOException) {}
                return true;
            }
        }
        return false;
    }

    public static IArchiveNode[] getSelectedNodes(ICommonViewerSite site) {
        ArrayList<IArchiveNode> list = new ArrayList<IArchiveNode>();
        IStructuredSelection selection = ArchivesActionProvider.getSelection(site);
        if (selection != null && !selection.isEmpty()) {
            for (Object o : selection) {
                if (!(o instanceof IArchiveNode)) continue;
                list.add((IArchiveNode)o);
            }
        }
        return list.toArray(new IArchiveNode[list.size()]);
    }

    public static IArchiveNode getSelectedNode(ICommonViewerSite site) {
        Object selected = ArchivesActionProvider.getSelectedObject(site);
        if (selected instanceof IArchiveNode) {
            return (IArchiveNode)selected;
        }
        return null;
    }

    public static Object getSelectedObject(ICommonViewerSite site) {
        IStructuredSelection selection = ArchivesActionProvider.getSelection(site);
        if (selection != null && !selection.isEmpty()) {
            return selection.getFirstElement();
        }
        return null;
    }

    public static IStructuredSelection getSelection(ICommonViewerSite site) {
        return (IStructuredSelection)site.getSelectionProvider().getSelection();
    }

    public static ImageDescriptor platformDescriptor(String desc) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(desc);
    }

    private Shell getShell() {
        return this.site.getShell();
    }

    public class ActionWrapper
    extends Action {
        private NewArchiveAction action;

        public ActionWrapper(NewArchiveAction act) {
            this.action = act;
        }

        public String getId() {
            return this.action.getId();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.action.getIconDescriptor();
        }

        public String getText() {
            return this.action.getLabel();
        }

        public void run() {
            this.action.getAction().run(null);
        }

        public void selectionChanged(IStructuredSelection sel) {
            this.action.getAction().selectionChanged((IAction)this, (ISelection)sel);
        }
    }
}

