/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.providers;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveAction;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveFileSetImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveFolderImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveImpl;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.ExtensionManager;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesRootContentProvider;

public class ArchivesLabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    public static final int IGNORE_FULL_PATHS = 1;
    public static final int SHOW_FULL_PATHS = 2;
    public static final int FOLLOW_PREFS_FULL_PATHS = 3;
    private int showFullPaths;

    public ArchivesLabelProvider() {
        this(3);
    }

    public ArchivesLabelProvider(int showFullPaths) {
        this.showFullPaths = showFullPaths;
    }

    public Image getImage(Object element) {
        Image image = this.internalGetImage(element);
        if (image != null) {
            image = PlatformUI.getWorkbench().getDecoratorManager().decorateImage(image, element);
        }
        return image;
    }

    public String getText(Object element) {
        String text = this.internalGetText(element);
        if (text != null) {
            text = PlatformUI.getWorkbench().getDecoratorManager().decorateText(text, element);
        }
        return text;
    }

    private Image internalGetImage(Object element) {
        block15: {
            block16: {
                IArchiveNode node;
                if (element instanceof ArchivesContentProviderDelegate.WrappedProject) {
                    switch (((ArchivesContentProviderDelegate.WrappedProject)element).getType()) {
                        case 1: {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                        }
                        case 2: {
                            return ArchivesSharedImages.getImage("icons/jar_obj.gif");
                        }
                    }
                }
                if (!(element instanceof IArchiveNode) || (node = (IArchiveNode)element) == null) break block15;
                if (!this.isInternal(node)) break block16;
                switch (node.getNodeType()) {
                    case 0: {
                        if (node instanceof ArchiveImpl) {
                            IArchive pkg = (IArchive)node;
                            if (!pkg.isExploded()) {
                                return ArchivesSharedImages.getImage("icons/jar_obj.gif");
                            }
                            return ArchivesSharedImages.getImage("icons/jar_exploded_obj.gif");
                        }
                    }
                    case 3: {
                        if (node instanceof ArchiveFolderImpl) {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                        }
                    }
                    case 2: {
                        if (node instanceof ArchiveFileSetImpl) {
                            return ArchivesSharedImages.getImage("icons/multiple_files.gif");
                        } else {
                            break;
                        }
                    }
                }
                break block15;
            }
            ILabelProvider delegate = ExtensionManager.findLabelProvider(element);
            if (delegate != null) {
                return delegate.getImage(element);
            }
        }
        return null;
    }

    private String internalGetText(Object element) {
        if (element == ArchivesRootContentProvider.NO_PROJECT) {
            return ArchivesUIMessages.SelectAProject;
        }
        if (element instanceof ArchivesContentProviderDelegate.WrappedProject) {
            switch (((ArchivesContentProviderDelegate.WrappedProject)element).getType()) {
                case 1: {
                    return ((ArchivesContentProviderDelegate.WrappedProject)element).getElement().getName();
                }
                case 2: {
                    return ArchivesUIMessages.ProjectArchives;
                }
            }
        }
        if (element instanceof ArchivesContentProviderDelegate.DelayProxy) {
            return ArchivesUIMessages.Loading;
        }
        if (element instanceof IArchiveNode) {
            if (this.isInternal((IArchiveNode)element)) {
                switch (((IArchiveNode)element).getNodeType()) {
                    case 0: {
                        return this.getPackageText((IArchive)element);
                    }
                    case 3: {
                        return this.getPackageFolderText((IArchiveFolder)element);
                    }
                    case 4: {
                        return this.getArchiveActionText((IArchiveAction)element);
                    }
                    case 2: {
                        return this.getPackageFileSetText((IArchiveFileSet)element);
                    }
                }
            } else {
                ILabelProvider delegate = ExtensionManager.findLabelProvider(element);
                if (delegate != null) {
                    return delegate.getText(element);
                }
            }
        }
        return element.toString();
    }

    private boolean isInternal(IArchiveNode node) {
        return node instanceof ArchiveImpl || node instanceof ArchiveFolderImpl || node instanceof ArchiveFileSetImpl;
    }

    private String getPackageFolderText(IArchiveFolder folder) {
        return folder.getName();
    }

    private String getPackageText(IArchive pkg) {
        String text = pkg.getName();
        if (this.showFullPaths == 2 || this.showFullPaths == 3 && PrefsInitializer.getBoolean("showPackageOutputPath")) {
            text = String.valueOf(text) + " [" + PathUtils.getAbsoluteLocation((IArchiveNode)pkg) + "]";
        }
        return text;
    }

    private String getArchiveActionText(IArchiveAction action) {
        return action.toString();
    }

    private String getPackageFileSetText(IArchiveFileSet fileset2) {
        if (fileset2 instanceof IArchiveStandardFileSet) {
            IArchiveStandardFileSet fileset = (IArchiveStandardFileSet)fileset2;
            boolean showFullPath = this.showFullPaths == 2 || this.showFullPaths == 3 && PrefsInitializer.getBoolean("showFullFilesetRootDir");
            boolean inWorkspace = fileset.isInWorkspace();
            String text = "";
            text = String.valueOf(text) + "+[" + fileset.getIncludesPattern() + "] ";
            if (fileset.getExcludesPattern() != null) {
                text = String.valueOf(text) + "-[" + fileset.getExcludesPattern() + "] : ";
            }
            text = showFullPath ? String.valueOf(text) + PathUtils.getAbsoluteLocation((IArchiveNode)fileset) : (inWorkspace ? String.valueOf(text) + fileset.getRawSourcePath() : String.valueOf(text) + new Path(PathUtils.getAbsoluteLocation((IArchiveNode)fileset)).lastSegment());
            return text;
        }
        return null;
    }
}

