/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.util.composites;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNode;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.util.composites.ArchiveNodeDestinationDialog;

public class ArchiveSourceDestinationComposite {
    private Text text;
    private Label pathImage;
    private Label relativeTo;
    private Button workspaceButton;
    private Button filesystemButton;
    private Button variablesButton;
    private Button wsRadioButton;
    private Button fsRadioButton;
    private String projectName;
    private boolean workspaceRelative = false;
    private IArchiveNode destinationNode;
    private String path;
    private int statusType;
    private String message;
    private double version;
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private String label;
    private Label destination;
    private Composite parent;
    private Composite relativeToEditor;

    public ArchiveSourceDestinationComposite(String label, Composite parent, String project, double version) {
        this.parent = parent;
        this.label = label;
        this.projectName = project;
        this.version = version;
        this.createWidgets();
        this.layoutWidgets();
        this.setWidgetData();
        this.addListeners();
    }

    protected void createWidgets() {
        this.destination = new Label(this.parent, 0);
        this.destination.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.pathImage = new Label(this.parent, 0);
        this.text = new Text(this.parent, 2052);
        this.relativeTo = new Label(this.parent, 0);
        this.relativeTo.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        new Label(this.parent, 0);
        this.relativeToEditor = new Composite(this.parent, 0);
        GridLayout gl = new GridLayout(6, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.relativeToEditor.setLayout((Layout)gl);
        this.fsRadioButton = new Button(this.relativeToEditor, 16);
        this.wsRadioButton = new Button(this.relativeToEditor, 16);
        this.variablesButton = new Button(this.relativeToEditor, 8);
        this.filesystemButton = new Button(this.relativeToEditor, 8);
        this.workspaceButton = new Button(this.relativeToEditor, 8);
        new Label(this.relativeToEditor, 0);
    }

    protected void layoutWidgets() {
        this.text.setLayoutData((Object)new GridData(768));
        this.relativeToEditor.setLayoutData((Object)new GridData(768));
    }

    protected void setWidgetData() {
        this.filesystemButton.setText(ArchivesUIMessages.Filesystem);
        this.workspaceButton.setText(ArchivesUIMessages.Workspace);
        this.variablesButton.setText(ArchivesUIMessages.Variables);
        this.wsRadioButton.setText(ArchivesUIMessages.Workspace2);
        this.fsRadioButton.setText(ArchivesUIMessages.Filesystem2);
        this.relativeTo.setText(ArchivesUIMessages.RelativeTo);
        this.pathImage.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        this.destination.setText(this.label);
    }

    protected void addListeners() {
        this.text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ArchiveSourceDestinationComposite.this.destinationNode = null;
                ArchiveSourceDestinationComposite.this.path = ArchiveSourceDestinationComposite.this.text.getText();
                ArchiveSourceDestinationComposite.this.textModified();
            }
        });
        this.filesystemButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArchiveSourceDestinationComposite.this.filesystemButtonPressed();
            }
        });
        this.workspaceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArchiveSourceDestinationComposite.this.workspaceButtonPressed();
            }
        });
        this.variablesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArchiveSourceDestinationComposite.this.variablesButtonPressed();
            }
        });
        this.fsRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArchiveSourceDestinationComposite.this.fsRadioButtonPressed();
            }
        });
        this.wsRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArchiveSourceDestinationComposite.this.wsRadioButtonPressed();
            }
        });
    }

    protected void textModified() {
        this.validateAndUpdateWidgets();
    }

    protected void filesystemButtonPressed() {
        this.browseFilesystem();
    }

    protected void workspaceButtonPressed() {
        this.openDestinationDialog();
    }

    protected void variablesButtonPressed() {
        this.variablesPressed();
    }

    protected void fsRadioButtonPressed() {
        this.radioPressed(this.fsRadioButton);
    }

    protected void wsRadioButtonPressed() {
        this.radioPressed(this.wsRadioButton);
    }

    protected void variablesPressed() {
        String expr;
        StringVariableSelectionDialog d = new StringVariableSelectionDialog(Display.getDefault().getActiveShell());
        if (d.open() == 0 && (expr = d.getVariableExpression()) != null) {
            this.destinationNode = null;
            this.path = String.valueOf(this.path) + expr;
            this.validateAndUpdateWidgets();
        }
    }

    protected void openDestinationDialog() {
        ArchiveNodeDestinationDialog dialog = new ArchiveNodeDestinationDialog(this.parent.getShell(), true, true);
        if (dialog.open() == 0) {
            Object result = dialog.getResult()[0];
            if (result instanceof IArchiveNode) {
                this.destinationNode = (IArchiveNode)result;
                this.path = null;
                this.workspaceRelative = true;
            } else if (result instanceof IContainer) {
                this.destinationNode = null;
                IPath tmpPath = ((IContainer)result).getFullPath();
                this.path = tmpPath.segment(0).equals(this.projectName) && this.getDescriptorVersion() >= 1.2 ? tmpPath.removeFirstSegments(1).makeRelative().toString() : ((IContainer)result).getFullPath().makeAbsolute().toString();
                this.workspaceRelative = true;
            }
            this.validateAndUpdateWidgets();
        }
    }

    protected void browseFilesystem() {
        String path;
        DirectoryDialog dialog = new DirectoryDialog(this.parent.getShell());
        String currentPath = null;
        try {
            currentPath = this.getTranslatedGlobalPath();
        }
        catch (CoreException coreException) {}
        if (currentPath != null && currentPath.length() > 0) {
            dialog.setFilterPath(currentPath);
        }
        if ((path = dialog.open()) != null) {
            this.destinationNode = null;
            this.path = path;
            this.workspaceRelative = false;
            this.validateAndUpdateWidgets();
        }
    }

    protected void radioPressed(Button button) {
        this.workspaceRelative = button == this.wsRadioButton;
        this.validateAndUpdateWidgets();
    }

    protected void validateAndUpdateWidgets() {
        block7: {
            String destText;
            this.statusType = 0;
            this.message = null;
            if (this.parent.isDisposed()) {
                return;
            }
            this.wsRadioButton.setEnabled(this.destinationNode == null);
            this.fsRadioButton.setEnabled(this.destinationNode == null);
            this.wsRadioButton.setSelection(this.destinationNode == null && this.workspaceRelative);
            this.fsRadioButton.setSelection(this.destinationNode == null && !this.workspaceRelative);
            Image image = this.destinationNode == null ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER") : ArchivesSharedImages.getImage("icons/jar_obj.gif");
            this.pathImage.setImage(image);
            String string = this.destinationNode == null ? (this.path == null ? "" : this.path) : (destText = ((INamedContainerArchiveNode)this.destinationNode).getName());
            if (!this.text.getText().equals(destText)) {
                this.text.setText(destText);
            }
            String translated = "";
            try {
                if (this.destinationNode == null) {
                    translated = this.getTranslatedGlobalPath();
                    if (translated == null || !new Path(translated).toFile().exists()) {
                        translated = NLS.bind((String)ArchivesUIMessages.PathDoesNotExistInFilesystem, (Object)translated);
                        PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                        this.statusType = 2;
                        this.message = translated;
                    }
                }
            }
            catch (CoreException ce) {
                translated = ce.getMessage();
                if (ce.getStatus().getSeverity() == 4) {
                    PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    this.statusType = 4;
                    this.message = ce.getMessage();
                }
                if (ce.getStatus().getSeverity() != 2) break block7;
                PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                this.statusType = 2;
                this.message = ce.getMessage();
            }
        }
        this.fireChange();
    }

    protected String getTranslatedGlobalPathOrError() {
        try {
            String postSub = ArchivesCore.getInstance().getVFS().performStringSubstitution(this.path, this.projectName, true);
            if (this.workspaceRelative) {
                IPath p = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath((IPath)new Path(postSub));
                if (p != null) {
                    return p.toString();
                }
                return NLS.bind((String)ArchivesUIMessages.ErrorConvertingPaths, (Object)postSub);
            }
            return postSub;
        }
        catch (CoreException e) {
            return NLS.bind((String)ArchivesUIMessages.ErrorStringSubstitution, (Object)e.getMessage());
        }
    }

    protected String getTranslatedGlobalPath() throws CoreException {
        try {
            IPath p = PathUtils.getGlobalLocation((String)this.path, (String)this.projectName, (boolean)this.workspaceRelative, (double)this.getDescriptorVersion());
            if (p != null) {
                return p.toString();
            }
            String ERROR = NLS.bind((String)ArchivesUIMessages.ErrorConvertingPaths, (Object)this.path);
            Status s = new Status(2, "org.jboss.ide.eclipse.archives.ui", ERROR);
            throw new CoreException((IStatus)s);
        }
        catch (CoreException e) {
            String ERROR = NLS.bind((String)ArchivesUIMessages.ErrorStringSubstitution, (Object)e.getMessage());
            Status s = new Status(4, "org.jboss.ide.eclipse.archives.ui", ERROR, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
    }

    public void init(IArchiveNode dest) {
        this.destinationNode = dest;
        this.path = null;
        this.workspaceRelative = true;
        this.validateAndUpdateWidgets();
    }

    public void init(String path, boolean workspaceRelative) {
        this.path = path;
        this.workspaceRelative = workspaceRelative;
        this.destinationNode = null;
        this.validateAndUpdateWidgets();
    }

    public boolean isValid() {
        return this.statusType != 4;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatusType() {
        return this.statusType;
    }

    public boolean isWorkspaceRelative() {
        return this.workspaceRelative;
    }

    public IArchiveNode getDestinationNode() {
        return this.destinationNode;
    }

    public String getPath() {
        return this.path;
    }

    public void setDescriptorVersion(double version) {
        this.version = version;
    }

    public double getDescriptorVersion() {
        return this.version;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChange() {
        Iterator<ChangeListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().compositeChanged();
        }
    }

    public static interface ChangeListener {
        public void compositeChanged();
    }
}

