/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.test.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.test.util.JobUtils;

public class IOUtil {
    public static void setContents(File file, String contents) throws IOException, CoreException {
        byte[] buffer = new byte[65536];
        ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes());
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            int avail = in.read(buffer);
            while (avail > 0) {
                out.write(buffer, 0, avail);
                avail = in.read(buffer);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getContents(IFile file) throws IOException, CoreException {
        return IOUtil.getContents(file.getLocation().toFile());
    }

    public static String getContents(File aFile) throws IOException {
        return new String(IOUtil.getBytesFromFile(aFile));
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void setContents(IFile file, int val) throws IOException, CoreException {
        IOUtil.setContents(file, "" + val);
    }

    public static void setContents(IFile file, String val) throws IOException, CoreException {
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(val.getBytes()), false, null);
        } else {
            file.setContents((InputStream)new ByteArrayInputStream(val.getBytes()), false, false, (IProgressMonitor)new NullProgressMonitor());
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        JobUtils.waitForIdle();
    }

    public static int countFiles(File root) {
        int count = 0;
        if (!root.isDirectory()) {
            return 1;
        }
        File[] children = root.listFiles();
        int i = 0;
        while (i < children.length) {
            count += IOUtil.countFiles(children[i]);
            ++i;
        }
        return count;
    }

    public static int countAllResources(File root) {
        int count = 0;
        if (!root.isDirectory()) {
            return 1;
        }
        File[] children = root.listFiles();
        int i = 0;
        while (i < children.length) {
            count += IOUtil.countAllResources(children[i]);
            ++i;
        }
        return 1 + count;
    }

    public static void unzipFile(IPath zipped, IPath toLoc) {
        toLoc.toFile().mkdirs();
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(zipped.toFile());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                if (entry.isDirectory()) {
                    toLoc.append(entry.getName()).toFile().mkdirs();
                    continue;
                }
                toLoc.append(entry.getName()).toFile().getParentFile().mkdirs();
                if (toLoc.append(entry.getName()).toFile().exists()) continue;
                String out = toLoc.append(entry.getName()).toOSString();
                FileOutputStream fos = new FileOutputStream(out);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

