/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.descriptors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultElement;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XMLDocumentRepository;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;

public class XPathFileResult {
    protected XPathQuery query;
    protected List<Node> nodeList;
    protected String fileLoc;
    protected XPathResultNode[] children;

    public XPathFileResult(XPathQuery query, String fileLoc, List<Node> nodeList) {
        this.query = query;
        this.fileLoc = fileLoc;
        this.nodeList = nodeList;
    }

    public String getFileLocation() {
        return this.fileLoc;
    }

    public XPathQuery getQuery() {
        return this.query;
    }

    public XPathResultNode[] getChildren() {
        if (this.children == null) {
            ArrayList<XPathResultNode> childList = new ArrayList<XPathResultNode>();
            Iterator<Node> i = this.nodeList.iterator();
            int z = 0;
            while (i.hasNext()) {
                childList.add(new XPathResultNode(i.next(), this.query.getAttribute(), z++, this));
            }
            this.children = childList.toArray(new XPathResultNode[childList.size()]);
        }
        return this.children;
    }

    public boolean isLoaded() {
        return this.children != null;
    }

    public class XPathResultNode {
        protected Node node;
        protected String attribute;
        protected boolean hasAttribute;
        protected int index;
        protected Object val;
        protected boolean dirty;
        protected XPathFileResult file;

        public XPathResultNode(Node node, String attribute, int index, XPathFileResult file) {
            this.node = node;
            this.attribute = attribute;
            this.index = index;
            this.hasAttribute = attribute != null && !attribute.equals("");
            this.file = file;
        }

        public XPathFileResult getFile() {
            return this.file;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean hasAttribute() {
            return this.hasAttribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getAttributeValue() {
            if (this.node instanceof DefaultElement) {
                return ((DefaultElement)this.node).attributeValue(this.attribute);
            }
            return "";
        }

        public Document getDocument() {
            if (this.node instanceof DefaultElement) {
                return ((DefaultElement)this.node).getDocument();
            }
            return null;
        }

        public String getText() {
            if (this.node != null && this.node instanceof DefaultElement) {
                if (!this.hasAttribute()) {
                    return ((DefaultElement)this.node).getText();
                }
                Attribute att = ((DefaultElement)this.node).attribute(this.attribute);
                if (att != null) {
                    return att.getValue();
                }
            }
            return "";
        }

        public void setText(String newValue) {
            if (this.node instanceof DefaultElement) {
                if (!this.hasAttribute()) {
                    ((DefaultElement)this.node).setText(newValue);
                } else {
                    ((DefaultElement)this.node).attribute(this.attribute).setValue(newValue);
                }
                this.dirty = true;
            }
        }

        public String elementAsXML() {
            return ((DefaultElement)this.node).asXML();
        }

        public String getElementName() {
            return ((DefaultElement)this.node).getName();
        }

        public String[] getElementChildrenNames() {
            DefaultElement element = (DefaultElement)this.node;
            List l = element.elements();
            ArrayList<String> names = new ArrayList<String>();
            for (DefaultElement child : l) {
                if (names.contains(child.getName())) continue;
                names.add(child.getName());
            }
            return names.toArray(new String[names.size()]);
        }

        public String[] getElementAttributeNames() {
            DefaultElement element = (DefaultElement)this.node;
            List l = element.attributes();
            ArrayList<String> names = new ArrayList<String>();
            for (DefaultAttribute child : l) {
                if (names.contains(child.getName())) continue;
                names.add(child.getName());
            }
            return names.toArray(new String[names.size()]);
        }

        public String[] getElementAttributeValues(String attName) {
            String[] stringArray;
            DefaultElement element = (DefaultElement)this.node;
            Attribute at = element.attribute(attName);
            if (at == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = at.getValue();
            }
            return stringArray;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public String getFileLocation() {
            return XPathFileResult.this.fileLoc;
        }

        public void saveDescriptor() {
            XMLDocumentRepository.saveDocument(this.node.getDocument(), XPathFileResult.this.fileLoc);
            this.dirty = false;
        }
    }
}

