/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.resolvers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.internal.variables.StringSubstitutionEngine;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.resolvers.ConfigNameResolver;
import org.jboss.ide.eclipse.as.core.server.IRuntimeProvider;
import org.jboss.tools.foundation.core.expressions.ExpressionResolutionException;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;

public class RuntimeVariableResolver
implements IVariableResolver {
    private IRuntime rt;
    private IRuntimeProvider rtProvider;

    public RuntimeVariableResolver(IRuntime rt) {
        this.rt = rt;
    }

    public RuntimeVariableResolver(IRuntimeProvider rt) {
        this.rtProvider = rt;
    }

    private IRuntime getRuntime() {
        return this.rt != null ? this.rt : (this.rtProvider != null ? this.rtProvider.getRuntime() : null);
    }

    private String getRuntimeName() {
        IRuntime r = this.getRuntime();
        return r == null ? null : r.getName();
    }

    public String resolve(String variable, String argument) throws ExpressionResolutionException {
        List<String> runtimeVars = Arrays.asList(ConfigNameResolver.ALL_VARIABLES);
        if (runtimeVars.contains(variable) && argument == null) {
            argument = this.getRuntimeName();
        }
        StringSubstitutionEngine engine = new StringSubstitutionEngine();
        try {
            return engine.performStringSubstitution(this.getVariablePattern(variable, argument), true, true, (IStringVariableManager)StringVariableManager.getDefault());
        }
        catch (CoreException ce) {
            throw new ExpressionResolutionException((Throwable)ce);
        }
    }

    private String getVariablePattern(String var, String arg) {
        if (arg != null) {
            return "${" + var + ":" + arg + "}";
        }
        return "${" + var + "}";
    }
}

