/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.EJBBean;
import org.eclipse.jst.server.core.JndiLaunchable;
import org.eclipse.jst.server.core.JndiObject;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.IURLProvider2;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.WebResource;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.IModuleArtifact2;
import org.jboss.ide.eclipse.as.core.server.IMultiModuleURLProvider;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.PortalUtil;

public class JBossLaunchAdapter
extends LaunchableAdapterDelegate {
    private static final String JAVA_NAMING_PROVIDER_URL_PROPKEY = "java.naming.provider.url";
    private static final String JAVA_NAMING_FACTORY_INITIAL_PROPKEY = "java.naming.factory.initial";
    private static final String JBOSS_PORTLET = "jboss.portlet";

    public Object getLaunchable(IServer server, IModuleArtifact moduleObject) {
        if (server != null) {
            ServerDelegate delegate = (ServerDelegate)server.loadAdapter(ServerDelegate.class, null);
            if (moduleObject instanceof IModuleArtifact2) {
                IModuleArtifact2 rootArt = (IModuleArtifact2)moduleObject;
                IModuleArtifact childArt = rootArt.getChildArtifact();
                IModule[] tree = rootArt.getModuleTree(server);
                if (delegate instanceof IMultiModuleURLProvider) {
                    URL root = ((IMultiModuleURLProvider)delegate).getModuleRootURL(tree);
                    return this.prepareHttpLaunchable((IModuleArtifact)rootArt, delegate, server, root);
                }
                moduleObject = childArt;
            }
            if (moduleObject instanceof Servlet || moduleObject instanceof WebResource) {
                URL root = ((IURLProvider)delegate).getModuleRootURL(moduleObject.getModule());
                return this.prepareHttpLaunchable(moduleObject, delegate, server, root);
            }
            if (moduleObject instanceof EJBBean || moduleObject instanceof JndiObject) {
                return this.prepareJndiLaunchable(moduleObject, delegate);
            }
        }
        return null;
    }

    private Object prepareJndiLaunchable(IModuleArtifact moduleObject, ServerDelegate delegate) {
        JndiLaunchable launchable = null;
        JBossServer server = (JBossServer)delegate;
        IPath p = new Path(server.getConfigDirectory()).append("jndi.properties");
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(p.toFile()));
        }
        catch (IOException iOException) {
            props.put(JAVA_NAMING_FACTORY_INITIAL_PROPKEY, "org.jnp.interfaces.NamingContextFactory");
            props.put(JAVA_NAMING_PROVIDER_URL_PROPKEY, "org.jboss.naming:org.jnp.interfaces");
        }
        if (moduleObject instanceof EJBBean) {
            EJBBean bean = (EJBBean)moduleObject;
            launchable = new JndiLaunchable(props, bean.getJndiName());
        }
        if (moduleObject instanceof JndiObject) {
            JndiObject jndi = (JndiObject)moduleObject;
            launchable = new JndiLaunchable(props, jndi.getJndiName());
        }
        return launchable;
    }

    private Object prepareHttpLaunchable(IModuleArtifact moduleObject, ServerDelegate delegate, IServer server, URL rootUrl) {
        try {
            WebResource resource;
            String path;
            URL url = rootUrl;
            if (moduleObject instanceof Servlet) {
                Servlet servlet = (Servlet)moduleObject;
                if (servlet.getAlias() != null) {
                    String path2 = servlet.getAlias();
                    if (path2.startsWith("/")) {
                        path2 = path2.substring(1);
                    }
                    url = new URL(url, path2);
                } else {
                    url = new URL(url, servlet.getName());
                }
            } else if (moduleObject instanceof WebResource && !(path = (resource = (WebResource)moduleObject).getPath().toString()).endsWith(".java")) {
                if (path != null && path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path != null && path.length() > 0) {
                    url = new URL(url, path);
                }
            }
            URL portletURL = this.getPortletURL(moduleObject, delegate, server);
            if (portletURL != null) {
                url = portletURL;
            }
            return new JBTCustomHttpLaunchable(moduleObject, url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private URL getPortletURL(IModuleArtifact moduleObject, ServerDelegate delegate, IServer server) {
        IRuntime runtime = server.getRuntime();
        IModule module = moduleObject.getModule();
        if (runtime == null || runtime.getLocation() == null || module == null || server == null || module.getProject() == null) {
            return null;
        }
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime == null || !(delegate instanceof JBossServer)) {
            return null;
        }
        try {
            String suffix;
            if (FacetedProjectFramework.hasProjectFacet((IProject)module.getProject(), (String)JBOSS_PORTLET) && (suffix = PortalUtil.getPortalSuffix((IJBossServerRuntime)jbossRuntime)) != null) {
                String urlString = "http://" + server.getHost();
                urlString = String.valueOf(urlString) + ":" + ((JBossServer)delegate).getJBossWebPort() + "/";
                URL url = new URL(urlString);
                return new URL(url, suffix);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    public static class JBTCustomHttpLaunchable {
        private IURLProvider2 urlProvider;
        private IModuleArtifact artifact;

        public JBTCustomHttpLaunchable(IModuleArtifact artifact, final URL url) {
            this.artifact = artifact;
            this.urlProvider = new IURLProvider2(){

                public URL getModuleRootURL(IModule module) {
                    return url;
                }

                public URL getLaunchableURL() {
                    return this.getModuleRootURL(null);
                }
            };
        }

        public JBTCustomHttpLaunchable(IURLProvider2 urlProvider) {
            this.urlProvider = urlProvider;
        }

        public URL getURL() {
            return this.urlProvider.getLaunchableURL();
        }

        public IModule getModule() {
            return this.artifact.getModule();
        }

        public IModuleArtifact getArtifact() {
            return this.artifact;
        }

        public IModule[] getModuleTree(IServer server) {
            IModule[] iModuleArray;
            if (this.artifact instanceof IModuleArtifact2) {
                iModuleArray = ((IModuleArtifact2)this.artifact).getModuleTree(server);
            } else {
                IModule[] iModuleArray2 = new IModule[1];
                iModuleArray = iModuleArray2;
                iModuleArray2[0] = this.getModule();
            }
            return iModuleArray;
        }
    }
}

