/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.IUserPrompter;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.JavaUtils;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.AbstractStartJavaServerLaunchDelegate;

public class StandardLocalJBossStartLaunchDelegate
extends AbstractStartJavaServerLaunchDelegate {
    protected void logStatus(IServer server, IStatus stat) {
        ServerLogger.getDefault().log(server, stat);
    }

    protected void initiatePolling(IServer server) {
        PollThreadUtils.pollServer(server, true);
    }

    protected IStatus isServerStarted(IServer server) {
        return PollThreadUtils.isServerStarted(server);
    }

    protected void validateServerStructure(IServer server) throws CoreException {
        IRuntime rt;
        IJBossServerRuntime rt2;
        IVMInstall vm;
        IControllableServerBehavior jbsBehavior = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        Trace.trace("/finest", "Verifying server structure");
        JBossExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getJBossExtendedProperties((IServerAttributes)server);
        IStatus status = props.verifyServerStructure();
        if (!status.isOK()) {
            ((ControllableServerBehavior)jbsBehavior).setServerStopped();
            throw new CoreException(status);
        }
        Trace.trace("/finest", "Verifying jdk is available if server requires jdk");
        boolean requiresJDK = props.requiresJDK();
        if (requiresJDK && !JavaUtils.isJDK((IVMInstall)(vm = (rt2 = RuntimeUtils.getJBossServerRuntime((IRuntime)(rt = server.getRuntime()))).getVM()))) {
            Trace.trace("/finest", "The VM to launch server '" + server.getName() + "' does not appear to be a JDK: " + vm.getInstallLocation().getAbsolutePath());
            Status stat = new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.launch_requiresJDK, (Object)server.getName(), (Object)vm.getInstallLocation().getAbsolutePath()));
            this.logStatus(server, (IStatus)stat);
        }
    }

    protected void cancelPolling(IServer server) {
        IControllableServerBehavior jbsBehavior = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        Object pt = ((ControllableServerBehavior)jbsBehavior).getSharedData("DeployableServerBehavior.PollThread");
        if (pt != null) {
            PollThreadUtils.cancelPolling(null, (PollThread)pt);
        }
    }

    protected IUserPrompter getPrompter() {
        return JBossServerCorePlugin.getDefault().getPrompter();
    }

    protected boolean addCustomHotcodeReplaceLogic(IServer server) {
        return server.getAttribute("org.jboss.ide.eclipse.as.wtp.core.server.launch.OverrideHotCodeReplace", true);
    }
}

