/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.extensions.polling.WebPortPoller;
import org.jboss.ide.eclipse.as.core.server.IDelegatingServerBehavior;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.INeedCredentials;
import org.jboss.ide.eclipse.as.core.server.IPollResultListener;
import org.jboss.ide.eclipse.as.core.server.IProvideCredentials;
import org.jboss.ide.eclipse.as.core.server.IServerProvider;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;

public class PollThreadUtils {
    public static String getPollerId(boolean expectedState, IServer server) {
        IJBossServer s = ServerConverter.getJBossServer((IServer)server);
        ServerAttributeHelper helper = s.getAttributeHelper();
        String key = expectedState ? "org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey" : "org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey";
        String defaultPoller = expectedState ? "org.jboss.ide.eclipse.as.core.runtime.server.WebPoller" : "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller";
        String pollerId = helper.getAttribute(key, defaultPoller);
        return pollerId;
    }

    public static IServerStatePoller getPoller(boolean expectedState, IServer server) {
        return PollThreadUtils.getPoller(PollThreadUtils.getPollerId(expectedState, server));
    }

    public static IServerStatePoller getPoller(String pollerId) {
        IServerStatePollerType type = ExtensionManager.getDefault().getPollerType(pollerId);
        if (type != null) {
            IServerStatePoller tempPoller = type.createPoller();
            tempPoller.setPollerType(type);
            return tempPoller;
        }
        return null;
    }

    public static void stopPolling(PollThread pollThread) {
        PollThreadUtils.cancelPolling(null, pollThread);
    }

    public static void cancelPolling(String message, PollThread pollThread) {
        if (pollThread != null) {
            if (message != null) {
                pollThread.cancel(message);
            } else {
                pollThread.cancel();
            }
        }
    }

    public static PollThread pollServer(boolean expectedState, IServerStatePoller poller, PollThread currentPollThread, IPollResultListener listener, IServer server) {
        PollThreadUtils.stopPolling(currentPollThread);
        PollThread newPollThread = new PollThread(expectedState, poller, listener, server);
        newPollThread.start();
        return newPollThread;
    }

    public static void requestCredentialsAsynch(final INeedCredentials requester, final List<String> requiredProps) {
        new Thread(){

            @Override
            public void run() {
                PollThreadUtils.requestCredentialsSynchronous(requester, (List<String>)requiredProps);
            }
        }.start();
    }

    public static void requestCredentialsSynchronous(INeedCredentials requester, List<String> requiredProps) {
        IProvideCredentials provider = ExtensionManager.getDefault().getFirstCredentialProvider((IServerProvider)requester, requiredProps);
        provider.handle(requester, requiredProps);
    }

    public static Properties requestCredentialsSynchronous(IServerProvider server, List<String> requiredProps) {
        NeedCredentials requester = new NeedCredentials(server.getServer(), requiredProps);
        IProvideCredentials provider = ExtensionManager.getDefault().getFirstCredentialProvider((IServerProvider)requester, requiredProps);
        provider.handle((INeedCredentials)requester, requiredProps);
        return requester.getReturnedCredentials();
    }

    @Deprecated
    public static IStatus isServerStarted(IDelegatingServerBehavior jbsBehavior) {
        return PollThreadUtils.isServerStarted(jbsBehavior.getServer());
    }

    public static IStatus isServerStarted(IServer server) {
        IServerStatePoller poller = PollThreadUtils.getPoller(true, server);
        return PollThreadUtils.isServerStarted(server, poller);
    }

    public static IStatus isServerStarted(IServer server, IServerStatePoller poller) {
        if (poller == null || !(poller instanceof IServerStatePoller2)) {
            poller = new WebPortPoller();
        }
        IStatus started = ((IServerStatePoller2)poller).getCurrentStateSynchronous(server);
        Trace.trace("/finer", "Checking if a server is already started: " + started.getMessage());
        return started;
    }

    public static void pollServer(IServer server, boolean expectedState) {
        IServerStatePoller poller = PollThreadUtils.getPoller(expectedState, server);
        PollThreadUtils.pollServer(server, expectedState, poller);
    }

    public static void pollServer(IServer server, boolean expectedState, IServerStatePoller poller) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        PollThread pollThread = (PollThread)beh.getSharedData("DeployableServerBehavior.PollThread");
        IPollResultListener listener = !expectedState ? PollThreadUtils.shutdownServerResultListener(server) : PollThreadUtils.launchServerResultListener(server);
        pollThread = PollThreadUtils.pollServer(expectedState, poller, pollThread, listener, server);
        beh.putSharedData("DeployableServerBehavior.PollThread", (Object)pollThread);
    }

    public static IPollResultListener launchServerResultListener(final IServer server) {
        return new IPollResultListener(){

            public void stateNotAsserted(boolean expectedState, boolean currentState) {
                server.stop(true);
            }

            public void stateAsserted(boolean expectedState, boolean currentState) {
                IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
                if (currentState) {
                    ((ControllableServerBehavior)beh).setServerStarted();
                } else {
                    ((ControllableServerBehavior)beh).setServerStopped();
                }
            }
        };
    }

    public static IPollResultListener shutdownServerResultListener(final IServer server) {
        return new IPollResultListener(){

            public void stateNotAsserted(boolean expectedState, boolean currentState) {
                IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
                ((ControllableServerBehavior)beh).setServerStarted();
            }

            public void stateAsserted(boolean expectedState, boolean currentState) {
                IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
                if (currentState) {
                    ((ControllableServerBehavior)beh).setServerStarted();
                } else {
                    ((ControllableServerBehavior)beh).setServerStopped();
                }
            }
        };
    }

    public static class NeedCredentials
    implements INeedCredentials {
        private IServer server;
        private List<String> requiredProps;
        private Properties returnedCredentials;

        public NeedCredentials(IServer server, List<String> requiredProps) {
            this.server = server;
            this.requiredProps = requiredProps;
        }

        public IServer getServer() {
            return this.server;
        }

        public List<String> getRequiredProperties() {
            return this.requiredProps;
        }

        public void provideCredentials(Properties credentials) {
            this.returnedCredentials = credentials;
        }

        public Properties getReturnedCredentials() {
            return this.returnedCredentials;
        }
    }
}

