/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcaster;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.MBeanAttributeInfoWrapper;
import org.jboss.tools.jmx.core.MBeanFeatureInfoWrapper;
import org.jboss.tools.jmx.core.MBeanNotificationInfoWrapper;
import org.jboss.tools.jmx.core.MBeanOperationInfoWrapper;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.core.util.EqualsUtil;

public class MBeanInfoWrapper
implements Comparable {
    private final ObjectName on;
    private final MBeanInfo info;
    private final MBeanServerConnection mbsc;
    private final ObjectNameNode parent;

    public MBeanInfoWrapper(ObjectName on, MBeanInfo info, MBeanServerConnection mbsc, ObjectNameNode parent) {
        Assert.isNotNull((Object)on);
        Assert.isNotNull((Object)info);
        Assert.isNotNull((Object)mbsc);
        this.on = on;
        this.info = info;
        this.mbsc = mbsc;
        this.parent = parent;
    }

    public IConnectionWrapper getConnectionWrapper() {
        return this.getRoot().getConnection();
    }

    public Root getRoot() {
        return this.parent.getRoot();
    }

    public ObjectNameNode getParent() {
        return this.parent;
    }

    public ObjectName getObjectName() {
        return this.on;
    }

    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public boolean isNotificationBroadcaster() {
        try {
            return this.mbsc.isInstanceOf(this.on, NotificationBroadcaster.class.getName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public MBeanAttributeInfoWrapper[] getMBeanAttributeInfoWrappers() {
        MBeanAttributeInfo[] attributes = this.info.getAttributes();
        MBeanAttributeInfoWrapper[] attrWrappers = new MBeanAttributeInfoWrapper[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            MBeanAttributeInfo attrInfo = attributes[i];
            attrWrappers[i] = new MBeanAttributeInfoWrapper(attrInfo, this);
            ++i;
        }
        return attrWrappers;
    }

    public MBeanOperationInfoWrapper[] getMBeanOperationInfoWrappers() {
        MBeanOperationInfo[] operations = this.info.getOperations();
        MBeanOperationInfoWrapper[] opWrappers = new MBeanOperationInfoWrapper[operations.length];
        int i = 0;
        while (i < operations.length) {
            MBeanOperationInfo opInfo = operations[i];
            opWrappers[i] = new MBeanOperationInfoWrapper(opInfo, this);
            ++i;
        }
        return opWrappers;
    }

    public MBeanNotificationInfoWrapper[] getMBeanNotificationInfoWrappers() {
        MBeanNotificationInfo[] notifications = this.info.getNotifications();
        MBeanNotificationInfoWrapper[] notificationWrappers = new MBeanNotificationInfoWrapper[notifications.length];
        int i = 0;
        while (i < notifications.length) {
            MBeanNotificationInfo opInfo = notifications[i];
            notificationWrappers[i] = new MBeanNotificationInfoWrapper(opInfo, this.on, this.mbsc);
            ++i;
        }
        return notificationWrappers;
    }

    public MBeanFeatureInfoWrapper[] getMBeanFeatureInfos() {
        MBeanAttributeInfo[] attributes = this.info.getAttributes();
        MBeanOperationInfo[] operations = this.info.getOperations();
        MBeanFeatureInfoWrapper[] o = new MBeanFeatureInfoWrapper[attributes.length + operations.length];
        int i = 0;
        while (i < attributes.length) {
            MBeanAttributeInfo attrInfo = attributes[i];
            o[i] = new MBeanAttributeInfoWrapper(attrInfo, this);
            ++i;
        }
        i = 0;
        while (i < operations.length) {
            MBeanOperationInfo opInfo = operations[i];
            o[attributes.length + i] = new MBeanOperationInfoWrapper(opInfo, this);
            ++i;
        }
        return o;
    }

    public int compareTo(Object object) {
        if (object instanceof MBeanInfoWrapper) {
            MBeanInfoWrapper other = (MBeanInfoWrapper)object;
            return this.on.toString().compareTo(other.on.toString());
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.mbsc == null ? 0 : this.mbsc.hashCode());
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MBeanInfoWrapper other = (MBeanInfoWrapper)obj;
        if (this.info == null) {
            return other.info == null;
        }
        if (other.info == null) {
            return false;
        }
        if (this.mbsc == null) {
            return other.mbsc == null;
        }
        if (!this.mbsc.equals(other.mbsc)) {
            return false;
        }
        if (this.on == null) {
            return other.on == null;
        }
        if (!this.on.equals(other.on)) {
            return false;
        }
        try {
            return this.info.equals(other.info);
        }
        catch (NullPointerException nullPointerException) {
            return EqualsUtil.infoEquals(this.info, other.info);
        }
    }
}

