/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.providers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderEventEmitter;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.providers.MBeanServerConnectionDescriptor;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;

public class DefaultConnectionWrapper
implements IConnectionWrapper {
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private Root root;
    private boolean isLoading;
    private boolean isConnected;
    private Map<String, String[]> environment;
    private MBeanServerConnectionDescriptor descriptor;

    public DefaultConnectionWrapper(MBeanServerConnectionDescriptor descriptor) throws MalformedURLException {
        this.descriptor = descriptor;
        this.isConnected = false;
        this.isLoading = false;
        String username = descriptor.getUserName();
        this.environment = new HashMap<String, String[]>();
        if (username != null && username.length() > 0) {
            String[] credentials = new String[]{username, descriptor.getPassword()};
            this.environment.put("jmx.remote.credentials", credentials);
        }
    }

    public MBeanServerConnectionDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider("org.jboss.tools.jmx.core.providers.DefaultConnectionProvider");
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean canControl() {
        return true;
    }

    @Override
    public synchronized void connect() throws IOException {
        this.connector = JMXConnectorFactory.connect(new JMXServiceURL(this.descriptor.getURL()), this.environment);
        this.connection = this.connector.getMBeanServerConnection();
        this.isConnected = true;
        ((IConnectionProviderEventEmitter)((Object)this.getProvider())).fireChanged(this);
    }

    @Override
    public synchronized void disconnect() throws IOException {
        this.root = null;
        this.isConnected = false;
        try {
            if (this.connector != null) {
                this.connector.close();
            }
        }
        finally {
            ((IConnectionProviderEventEmitter)((Object)this.getProvider())).fireChanged(this);
        }
        this.connector = null;
        this.connection = null;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public Root getRoot() {
        return this.root;
    }

    @Override
    public void loadRoot(IProgressMonitor monitor) throws CoreException {
        if (this.isConnected && this.root == null && !this.isLoading) {
            try {
                this.isLoading = true;
                this.root = NodeUtils.createObjectNameTree(this, monitor);
            }
            finally {
                this.isLoading = false;
            }
        }
    }

    @Override
    public void run(IJMXRunnable runnable) throws JMXException {
        try {
            runnable.run(this.connection);
        }
        catch (Exception e) {
            Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRunningJMXCode, (Throwable)e);
            throw new JMXException((IStatus)s);
        }
    }

    @Override
    public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
        this.run(runnable);
    }
}

