/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.jboss.ide.eclipse.as.wtp.ui.WTPOveridePlugin;
import org.jboss.ide.eclipse.as.wtp.ui.wizards.xpl.export.FullPublishToServerWizard;

public abstract class AbstractModuleCommandHandler
extends AbstractHandler
implements IHandler {
    private static final String FAMILY = "org.eclipse.wst.server.ui.family";

    public abstract Object execute(ExecutionEvent var1) throws ExecutionException;

    protected IModule getModule(IResource resource) {
        if (resource != null) {
            ArrayList<IModule> possibleModules = new ArrayList<IModule>();
            IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)resource);
            if (moduleArtifacts != null && moduleArtifacts.length > 0) {
                int i = 0;
                while (i < moduleArtifacts.length) {
                    if (moduleArtifacts[i].getModule() != null && !possibleModules.contains(moduleArtifacts[i].getModule())) {
                        possibleModules.add(moduleArtifacts[i].getModule());
                    }
                    ++i;
                }
            }
            return this.promptForModule(possibleModules);
        }
        return null;
    }

    protected IModule promptForModule(ArrayList<IModule> modules) {
        if (modules.size() > 0) {
            if (modules.size() == 1) {
                return modules.get(0);
            }
            return modules.get(0);
        }
        return null;
    }

    public IServer[] getCompatibleServers(IModule module) {
        IServer[] servers = ServerCore.getServers();
        IModuleType mt = module.getModuleType();
        int size = servers.length;
        if (servers != null && size > 0) {
            ArrayList<IServer> ret = new ArrayList<IServer>();
            int i = 0;
            while (i < size) {
                IModuleType[] stmt;
                IRuntimeType rtt = servers[i].getServerType().getRuntimeType();
                IModuleType[] iModuleTypeArray = stmt = rtt == null ? new IModuleType[]{} : rtt.getModuleTypes();
                if (ServerUtil.isSupportedModule((IModuleType[])stmt, (String)mt.getId(), null)) {
                    ret.add(servers[i]);
                }
                ++i;
            }
            return ret.toArray(new IServer[ret.size()]);
        }
        return new IServer[0];
    }

    public IServer getServer(IModule module, IModuleArtifact moduleArtifact, IProgressMonitor monitor) throws CoreException {
        IServer[] servers;
        IServer server = ServerCore.getDefaultServer((IModule)module);
        if (server != null && !ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)monitor)) {
            IServerWorkingCopy wc = server.createWorkingCopy();
            try {
                ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                wc.save(false, monitor);
            }
            catch (CoreException ce) {
                WTPOveridePlugin.logError(ce);
                server = null;
            }
        }
        if ((servers = this.getCompatibleServers(module)).length == 1) {
            return servers[0];
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (server == null) {
            FullPublishToServerWizard wizard = new FullPublishToServerWizard(module, moduleArtifact);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() == 1) {
                if (monitor != null) {
                    monitor.setCanceled(true);
                }
                return null;
            }
            this.joinJobFamily();
            server = wizard.getServer();
            boolean preferred = wizard.isPreferredServer();
            if (server != null && preferred) {
                try {
                    ServerCore.setDefaultServer((IModule)module, (IServer)server, (IProgressMonitor)monitor);
                }
                catch (CoreException ce) {
                    String message = "Could not save server preference information.";
                    ErrorDialog.openError((Shell)shell, (String)"Server Error", (String)message, (IStatus)ce.getStatus());
                }
            }
        }
        this.joinJobFamily();
        return server;
    }

    private void joinJobFamily() {
        try {
            Job.getJobManager().join((Object)FAMILY, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
    }

    public boolean isEnabled() {
        IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
        IModule module = this.getModule(resource);
        return module != null;
    }

    public boolean isHandled() {
        return true;
    }
}

