/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans.project;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.ui.mbeans.Activator;
import org.jboss.ide.eclipse.as.ui.mbeans.project.IJBossSARFacetDataModelProperties;
import org.jboss.ide.eclipse.as.ui.mbeans.project.SARVirtualComponent;
import org.osgi.service.prefs.BackingStoreException;

public class JBossSARFacetInstallationDelegate
implements IDelegate {
    private IDataModel model;

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.model = (IDataModel)config;
        IJavaProject jproj = JavaCore.create((IProject)project);
        this.createProjectStructure(project);
        WtpUtils.addNatures((IProject)project);
        SARVirtualComponent factory = new SARVirtualComponent();
        IVirtualComponent newComponent = factory.createComponent(project);
        String outputLoc = jproj.readOutputLocation().removeFirstSegments(1).toString();
        newComponent.create(0, null);
        newComponent.setMetaProperty("java-output-path", outputLoc);
        IVirtualFolder jbiRoot = newComponent.getRootFolder();
        String resourcesFolder = this.model.getStringProperty("JBoss.Project.Content_Folder");
        jbiRoot.createLink((IPath)new Path("/" + resourcesFolder), 0, null);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 3 && cpe.getPath().removeFirstSegments(1).segmentCount() > 0) {
                try {
                    IFolder srcFolder = ws.getRoot().getFolder(cpe.getPath());
                    IVirtualResource[] virtualResource = ComponentCore.createResources((IResource)srcFolder);
                    if (virtualResource.length == 0) {
                        jbiRoot.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            }
            ++i;
        }
    }

    private void createProjectStructure(IProject project) throws CoreException {
        String strContentFolder = this.model.getStringProperty("JBoss.Project.Content_Folder");
        project.setPersistentProperty(IJBossSARFacetDataModelProperties.QNAME_SAR_CONTENT_FOLDER, strContentFolder);
        String qualifier = JBossServerCorePlugin.getDefault().getBundle().getSymbolicName();
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        if (node != null) {
            node.putDouble("jboss.sar.project.project.version", 1.0);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        IFolder sarContent = project.getFolder(strContentFolder);
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.createFolder(sarContent.getFolder("META-INF"), (IProgressMonitor)monitor);
        project.refreshLocal(0, null);
    }

    private void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent != null && !parent.exists()) {
                this.createFolder((IFolder)parent, monitor);
            }
            folder.create(true, true, monitor);
        }
    }
}

