/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.tools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IAgentLoadHandler;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Messages;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Tools;
import org.jboss.tools.jmx.jvmmonitor.tools.Activator;

public class AgentLoadHandler
implements IAgentLoadHandler {
    private String agentJarPath;
    private boolean isAgentLoaded = false;

    public AgentLoadHandler() {
        this.searchAgentJar();
    }

    public void loadAgent(IActiveJvm jvm) throws JvmCoreException {
        block15: {
            if (this.agentJarPath == null) {
                return;
            }
            Tools tools = Tools.getInstance();
            Object virtualMachine = null;
            try {
                try {
                    virtualMachine = tools.invokeAttach(jvm.getPid());
                    tools.invokeLoadAgent(virtualMachine, this.agentJarPath, this.agentJarPath);
                    this.isAgentLoaded = true;
                }
                catch (JvmCoreException e) {
                    Activator.log(4, NLS.bind((String)Messages.loadAgentFailedMsg, (Object)this.agentJarPath), e);
                    if (virtualMachine != null) {
                        try {
                            tools.invokeDetach(virtualMachine);
                        }
                        catch (JvmCoreException jvmCoreException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (virtualMachine != null) {
                    try {
                        tools.invokeDetach(virtualMachine);
                    }
                    catch (JvmCoreException jvmCoreException) {}
                }
                throw throwable;
            }
            if (virtualMachine != null) {
                try {
                    tools.invokeDetach(virtualMachine);
                }
                catch (JvmCoreException jvmCoreException) {}
            }
        }
    }

    public boolean isAgentLoaded() {
        return this.isAgentLoaded;
    }

    private void searchAgentJar() {
        File agentJar = null;
        try {
            URL entry = org.jboss.tools.jmx.jvmmonitor.core.Activator.getDefault().getBundle().getEntry("lib/jvmmonitor-agent.jar");
            URL entryFileUrl = FileLocator.toFileURL((URL)entry);
            agentJar = new File(entryFileUrl.getPath());
        }
        catch (IOException e) {
            Activator.log(4, Messages.corePluginNoFoundMsg, new Exception(e));
            return;
        }
        if (agentJar != null) {
            this.agentJarPath = agentJar.getAbsolutePath();
            if (!agentJar.exists()) {
                Activator.log(4, NLS.bind((String)Messages.agentJarNotFoundMsg, (Object)agentJar.getAbsolutePath()), new Exception());
            } else {
                Activator.log(1, NLS.bind((String)Messages.agentJarFoundMsg, (Object)this.agentJarPath), new Exception());
            }
        }
    }
}

