/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core.subsystems;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.rse.core.RSELaunchConfigProperties;
import org.jboss.ide.eclipse.as.rse.core.subsystems.RSECommandLineShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;

public class RSEJBossCommandLineShutdownController
extends RSECommandLineShutdownController
implements IServerShutdownController {
    public void stopImpl(boolean force) {
        this.removeScanners();
        super.stopImpl(force);
    }

    protected void removeScanners() {
        JBossExtendedProperties properties;
        boolean removeScanners = this.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", true);
        if (removeScanners && (properties = (JBossExtendedProperties)this.getServer().loadAdapter(JBossExtendedProperties.class, null)) != null) {
            properties.getDeploymentScannerModifier().removeAddedDeploymentScanners(this.getServer());
        }
    }

    protected String getShutdownCommand(IServer server) throws CoreException {
        ILaunchConfiguration config = this.getServer().getLaunchConfiguration(false, (IProgressMonitor)new NullProgressMonitor());
        return new RSELaunchConfigProperties().getShutdownCommand(config, this.getDefaultShutdownCommand(server));
    }

    protected String getDefaultShutdownCommand(IServer server) {
        JBossServer jbs = (JBossServer)ServerConverter.getJBossServer((IServer)this.getServer());
        String defaultArgs = jbs.getExtendedProperties().getDefaultLaunchArguments().getDefaultStopArgs();
        return defaultArgs;
    }

    protected PollThread getPollThread() {
        return (PollThread)this.getControllableBehavior().getSharedData("DeployableServerBehavior.PollThread");
    }

    protected void clearPollThread() {
        this.getControllableBehavior().putSharedData("DeployableServerBehavior.PollThread", null);
    }

    protected boolean isServerStarted() {
        return PollThreadUtils.isServerStarted((IServer)this.getServer()).isOK();
    }

    protected void beforeCommandExecuted() {
        PollThreadUtils.pollServer((IServer)this.getServer(), (boolean)false);
    }

    protected void afterCommandExecuted() {
    }

    protected void handleShutdownFailed() {
        if (this.getPollThread() != null) {
            this.getPollThread().cancel();
            this.clearPollThread();
        }
        super.handleShutdownFailed();
    }
}

