/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetDialog;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetLabelProvider;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetUtil;
import org.jboss.ide.eclipse.as.ui.preferences.ServerTypePreferencePage;

public class DefaultFilesetPreferencePage
extends ServerTypePreferencePage {
    protected Control createContents(Composite parent) {
        this.rootComp = new FilesetPreferenceComposite(parent, 0);
        this.rootComp.setLayoutData((Object)new GridData(1808));
        this.rootComp.layout();
        return this.rootComp;
    }

    public boolean performOk() {
        String[] changed2 = this.rootComp.getChanged();
        int i = 0;
        while (i < changed2.length) {
            ArrayList list = this.rootComp.getDataForComboSelection(changed2[i]);
            Fileset[] arr = list.toArray(new Fileset[list.size()]);
            IPath fileToWrite = FilesetUtil.DEFAULT_FS_ROOT.append(changed2[i]);
            FilesetUtil.saveFilesets(fileToWrite.toFile(), arr);
            ++i;
        }
        this.rootComp.clearChanged();
        return true;
    }

    public static class FilesetPreferenceComposite
    extends ServerTypePreferencePage.ServerTypePreferenceComposite {
        public FilesetPreferenceComposite(Composite parent, int style) {
            super(parent, style);
        }

        public String getDescriptionLabel() {
            return Messages.DefaultFilesetsLabel;
        }

        protected void addPressed() {
            FilesetDialog d = new FilesetDialog(this.addButton.getShell(), "", null);
            d.setShowViewer(false);
            if (d.open() == 0) {
                Fileset fs = d.getFileset();
                this.addObject(fs);
            }
        }

        protected LabelProvider getLabelProvider() {
            return new FilesetLabelProvider();
        }

        protected void initializeDataModel() {
            super.initializeDataModel();
        }

        protected Object[] getCurrentSelectionDataModel() {
            return this.getCurrentServerSets();
        }

        protected Fileset[] getCurrentServerSets() {
            String id = this.getCurrentId();
            ArrayList<Fileset> list = new ArrayList<Fileset>();
            if (id != null && (list = this.getDataForComboSelection(id)) == null) {
                IPath fileToRead = FilesetUtil.DEFAULT_FS_ROOT.append(id);
                Fileset[] sets = FilesetUtil.loadFilesets(fileToRead.toFile(), null);
                list = new ArrayList<Fileset>();
                list.addAll(Arrays.asList(sets));
                this.cacheMap.put(id, list);
            }
            return list.toArray(new Fileset[list.size()]);
        }
    }
}

