/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.as.core.resolvers.ConfigNameResolver;
import org.jboss.ide.eclipse.as.core.resolvers.RuntimeVariableResolver;
import org.jboss.ide.eclipse.as.core.server.IRuntimeProvider;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;

public class Fileset
implements Cloneable,
IRuntimeProvider {
    private static final String HASH_SEPARATOR = "::_::";
    private static final String SEP = "\n";
    private String name;
    private String folder;
    private String includesPattern;
    private String excludesPattern;
    private IRuntime runtime;
    private IServer server;
    private IVariableResolver resolver;

    public Fileset() {
    }

    public Fileset(String string) {
        this.excludesPattern = "";
        this.includesPattern = "";
        this.folder = "";
        this.name = "";
        String[] parts = string.split(SEP);
        this.name = parts.length <= 0 ? null : parts[0];
        this.folder = parts.length <= 1 ? null : parts[1];
        this.includesPattern = parts.length <= 2 ? null : parts[2];
        this.excludesPattern = parts.length <= 3 ? null : parts[3];
        this.setVariableResolver((IVariableResolver)new RuntimeVariableResolver((IRuntimeProvider)this));
    }

    public Fileset(String name, String folder, String inc, String exc) {
        this.name = name;
        this.folder = folder;
        this.includesPattern = inc;
        this.excludesPattern = exc;
        this.setVariableResolver((IVariableResolver)new RuntimeVariableResolver((IRuntimeProvider)this));
    }

    public String toString() {
        return String.valueOf(this.name) + SEP + this.folder + SEP + this.includesPattern + SEP + this.excludesPattern;
    }

    public String getFolder() {
        String result = new ExpressionResolver(this.resolver).resolve(this.folder);
        Path p = new Path(result);
        if (!p.isAbsolute()) {
            String s2 = String.valueOf(ConfigNameResolver.getVariablePattern((String)"jboss_server_home")) + '/' + result;
            result = new ExpressionResolver(this.resolver).resolve(s2);
        }
        return result;
    }

    public static String getFolder(String folder, IRuntime runtime) {
        return Fileset.getFolder(folder, runtime, true);
    }

    public static String getFolder(String folder, IRuntime runtime, boolean ignoreError) {
        String tmp = new ConfigNameResolver().performSubstitutions(folder, runtime == null ? null : runtime.getName(), ignoreError);
        Path p = new Path(tmp);
        if (!p.isAbsolute() && runtime != null) {
            p = runtime.getLocation().append((IPath)p);
        }
        return p.toString();
    }

    public String getRawFolder() {
        return this.folder == null ? "" : this.folder;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String getExcludesPattern() {
        return this.excludesPattern == null ? "" : this.excludesPattern;
    }

    public String getResolvedExclude() {
        String pattern = this.excludesPattern == null ? "" : this.excludesPattern;
        String resolved = new ExpressionResolver(this.resolver).resolveIgnoreErrors(pattern);
        return resolved;
    }

    public String getIncludesPattern() {
        return this.includesPattern == null ? "" : this.includesPattern;
    }

    public String getResolvedIncludesPattern() {
        String pattern = this.includesPattern == null ? "" : this.includesPattern;
        String resolved = new ExpressionResolver(this.resolver).resolveIgnoreErrors(pattern);
        return resolved;
    }

    public void setExcludesPattern(String excludesPattern) {
        this.excludesPattern = excludesPattern;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setIncludesPattern(String includesPattern) {
        this.includesPattern = includesPattern;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IServer getServer() {
        return this.server;
    }

    public void setServer(IServer server) {
        this.server = server;
        this.runtime = server == null ? null : server.getRuntime();
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(IRuntime rt) {
        this.runtime = rt;
        if (this.server == null || this.server.getRuntime().equals(rt)) {
            this.server = null;
        }
    }

    public Object clone() {
        Fileset fs = new Fileset(this.name, this.folder, this.includesPattern, this.excludesPattern);
        fs.setServer(this.server);
        fs.setRuntime(this.runtime);
        return fs;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Fileset)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Fileset o = (Fileset)other;
        return o.getName().equals(this.getName()) && o.getRawFolder().equals(this.getRawFolder()) && o.getIncludesPattern().equals(this.getIncludesPattern()) && o.getExcludesPattern().equals(this.getExcludesPattern());
    }

    public int hashCode() {
        return (String.valueOf(this.name) + HASH_SEPARATOR + this.folder + HASH_SEPARATOR + this.includesPattern + HASH_SEPARATOR + this.excludesPattern + HASH_SEPARATOR).hashCode();
    }

    public IPath[] findPaths() {
        String dir = this.getFolder();
        String includes = this.getResolvedIncludesPattern();
        String excludes = this.getResolvedExclude();
        return Fileset.findPaths(dir, includes, excludes);
    }

    public static IPath[] findPaths(String dir, String includes, String excludes) {
        return Fileset.findPaths(dir, includes, excludes, null);
    }

    public static IPath[] findPaths(String dir, String includes, String excludes, IProgressMonitor monitor) {
        try {
            DirectoryScannerFactory.DirectoryScannerExtension scanner;
            if (dir != null && new File(dir).exists() && (scanner = DirectoryScannerFactory.createDirectoryScanner((String)dir, null, (String)includes, (String)excludes, null, (boolean)false, (double)1.0, (boolean)true, (IProgressMonitor)monitor)) != null) {
                String[] files = scanner.getIncludedFiles();
                IPath[] paths = new IPath[files.length];
                int i = 0;
                while (i < files.length) {
                    paths[i] = new Path(files[i]);
                    ++i;
                }
                return paths;
            }
        }
        catch (IllegalStateException illegalStateException) {
            return new IPath[0];
        }
        catch (RuntimeException runtimeException) {
            return new IPath[0];
        }
        return new IPath[0];
    }

    protected void setVariableResolver(IVariableResolver resolver) {
        this.resolver = resolver;
    }
}

